// Made with Amplify Shader Editor v1.9.1.8
// Available at the Unity Asset Store - http://u3d.as/y3X 
Shader "Sprite Shaders Ultimate/3D Lit URP SSU"
{
	Properties
	{
		[HideInInspector] _EmissionColor("Emission Color", Color) = (1,1,1,1)
		[HideInInspector] _AlphaCutoff("Alpha Cutoff ", Range(0, 1)) = 0.5
		_MainTex("MainTex", 2D) = "white" {}
		_ShadowClip("Shadow Clip", Range( 0 , 1)) = 0.5
		_NormalMap("Normal Map", 2D) = "bump" {}
		_NormalIntensity("Normal Intensity", Float) = 1
		_Smoothness("Smoothness", Range( 0 , 1)) = 0.5
		_Metallic("Metallic", Range( 0 , 1)) = 0
		[Toggle(_METALLICMAPTOGGLE_ON)] _MetallicMapToggle("Metallic Map Toggle", Float) = 0
		_MetallicMap("Metallic Map", 2D) = "white" {}
		[Toggle(_EMISSIONTOGGLE_ON)] _EmissionToggle("Emission Toggle", Float) = 0
		[HDR]_EmissionTint("Emission Tint", Color) = (2.996078,0.1568628,0.1568628,0)
		_EmissionMap("Emission Map", 2D) = "white" {}
		[Toggle(_VERTEXTINTFIRST_ON)] _VertexTintFirst("Vertex Tint First", Float) = 0
		[Toggle(_PIXELPERFECTSPACE_ON)] _PixelPerfectSpace("Pixel Perfect Space", Float) = 0
		[Toggle(_PIXELPERFECTUV_ON)] _PixelPerfectUV("Pixel Perfect UV", Float) = 0
		[Toggle(_SPRITESHEETFIX_ON)] _SpriteSheetFix("Sprite Sheet Fix", Float) = 0
		_SpriteSheetRect("Sprite Sheet Rect", Vector) = (0,0,1,1)
		[Toggle(_TILINGFIX_ON)] _TilingFix("Tiling Fix", Float) = 0
		[Toggle(_BAKEDMATERIAL_ON)] _BakedMaterial("Baked Material", Float) = 0
		[KeywordEnum(UV,UV_Raw,Object,Object_Scaled,World,UI_Graphic,Screen)] _ShaderSpace("Shader Space", Float) = 0
		_PixelsPerUnit("Pixels Per Unit", Float) = 100
		_ScreenWidthUnits("Screen Width Units", Float) = 10
		_RectWidth("Rect Width", Float) = 100
		_RectHeight("Rect Height", Float) = 100
		[KeywordEnum(None,Full,Mask,Dissolve,Spread)] _ShaderFading("Shader Fading", Float) = 0
		_FadingFade("Fading: Fade", Range( 0 , 1)) = 1
		_FadingPosition("Fading: Position", Vector) = (0,0,0,0)
		_FadingWidth("Fading: Width", Float) = 0.3
		_FadingNoiseFactor("Fading: Noise Factor", Float) = 0.2
		_FadingNoiseScale("Fading: Noise Scale", Vector) = (0.2,0.2,0,0)
		_FadingMask("Fading: Mask", 2D) = "white" {}
		[Toggle(_TOGGLEUNSCALEDTIME_ON)] _ToggleUnscaledTime("Toggle: Unscaled Time", Float) = 0
		[Toggle(_TOGGLECUSTOMTIME_ON)] _ToggleCustomTime("Toggle: Custom Time", Float) = 0
		_TimeValue("Time: Value", Float) = 0
		[Toggle(_TOGGLETIMESPEED_ON)] _ToggleTimeSpeed("Toggle: Time Speed", Float) = 0
		_TimeSpeed("Time: Speed", Float) = 1
		[Toggle(_TOGGLETIMEFPS_ON)] _ToggleTimeFPS("Toggle: Time FPS", Float) = 0
		_TimeFPS("Time: FPS", Float) = 5
		[Toggle(_TOGGLETIMEFREQUENCY_ON)] _ToggleTimeFrequency("Toggle: Time Frequency", Float) = 0
		_TimeFrequency("Time: Frequency", Float) = 2
		_TimeRange("Time: Range", Float) = 0.5
		_UberNoiseTexture("Uber Noise Texture", 2D) = "white" {}
		[Toggle(_ENABLESTRONGTINT_ON)] _EnableStrongTint("Enable Strong Tint", Float) = 0
		_StrongTintFade("Strong Tint: Fade", Range( 0 , 1)) = 1
		[HDR][NoAlpha]_StrongTintTint("Strong Tint: Tint", Color) = (1,1,1,1)
		[Toggle(_STRONGTINTCONTRASTTOGGLE_ON)] _StrongTintContrastToggle("Strong Tint: Contrast Toggle", Float) = 0
		_StrongTintContrast("Strong Tint: Contrast", Float) = 0
		[Toggle(_STRONGTINTMASKTOGGLE_ON)] _StrongTintMaskToggle("Strong Tint: Mask Toggle", Float) = 0
		_StrongTintMask("Strong Tint: Mask", 2D) = "white" {}
		[Toggle(_ENABLEADDCOLOR_ON)] _EnableAddColor("Enable Add Color", Float) = 0
		_AddColorFade("Add Color: Fade", Range( 0 , 1)) = 1
		[HDR]_AddColorColor("Add Color: Color", Color) = (2.996078,0,0,0)
		[Toggle(_ADDCOLORCONTRASTTOGGLE_ON)] _AddColorContrastToggle("Add Color: Contrast Toggle", Float) = 0
		_AddColorContrast("Add Color: Contrast", Float) = 0.5
		[Toggle(_ADDCOLORMASKTOGGLE_ON)] _AddColorMaskToggle("Add Color: Mask Toggle", Float) = 0
		_AddColorMask("Add Color: Mask", 2D) = "white" {}
		[Toggle(_ENABLEALPHATINT_ON)] _EnableAlphaTint("Enable Alpha Tint", Float) = 0
		_AlphaTintFade("Alpha Tint: Fade", Range( 0 , 1)) = 1
		[HDR]_AlphaTintColor("Alpha Tint: Color", Color) = (95.87451,5.019608,95.87451,0)
		_AlphaTintMinAlpha("Alpha Tint: Min Alpha", Range( 0 , 1)) = 0.02
		[Toggle(_ENABLESHADOW_ON)] _EnableShadow("Enable Shadow", Float) = 0
		_ShadowFade("Shadow: Fade", Range( 0 , 1)) = 1
		_ShadowOffset("Shadow: Offset", Vector) = (0.05,-0.05,0,0)
		_ShadowColor("Shadow: Color", Color) = (0,0,0,0)
		[Toggle(_ENABLEBRIGHTNESS_ON)] _EnableBrightness("Enable Brightness", Float) = 0
		_Brightness("Brightness", Float) = 1
		[Toggle(_ENABLECONTRAST_ON)] _EnableContrast("Enable Contrast", Float) = 0
		_Contrast("Contrast", Float) = 1
		[Toggle(_ENABLESATURATION_ON)] _EnableSaturation("Enable Saturation", Float) = 0
		_Saturation("Saturation", Float) = 1
		[Toggle(_ENABLEHUE_ON)] _EnableHue("Enable Hue", Float) = 0
		_Hue("Hue", Range( -1 , 1)) = 0
		[Toggle(_ENABLERECOLORRGB_ON)] _EnableRecolorRGB("Enable Recolor RGB", Float) = 0
		_RecolorRGBFade("Recolor RGB: Fade", Range( 0 , 1)) = 1
		[HDR]_RecolorRGBRedTint("Recolor RGB: Red Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBGreenTint("Recolor RGB: Green Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBBlueTint("Recolor RGB: Blue Tint", Color) = (1,1,1,0.5019608)
		[Toggle(_RECOLORRGBTEXTURETOGGLE_ON)] _RecolorRGBTextureToggle("Recolor RGB: Texture Toggle", Float) = 0
		_RecolorRGBTexture("Recolor RGB: Texture", 2D) = "white" {}
		[Toggle(_ENABLERECOLORRGBYCP_ON)] _EnableRecolorRGBYCP("Enable Recolor RGBYCP", Float) = 0
		_RecolorRGBYCPFade("Recolor RGBYCP: Fade", Range( 0 , 1)) = 1
		[HDR]_RecolorRGBYCPRedTint("Recolor RGBYCP: Red Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBYCPYellowTint("Recolor RGBYCP: Yellow Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBYCPGreenTint("Recolor RGBYCP: Green Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBYCPCyanTint("Recolor RGBYCP: Cyan Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBYCPBlueTint("Recolor RGBYCP: Blue Tint", Color) = (1,1,1,0.5019608)
		[HDR]_RecolorRGBYCPPurpleTint("Recolor RGBYCP: Purple Tint", Color) = (1,1,1,0.5019608)
		[Toggle(_RECOLORRGBYCPTEXTURETOGGLE_ON)] _RecolorRGBYCPTextureToggle("Recolor RGBYCP: Texture Toggle", Float) = 0
		_RecolorRGBYCPTexture("Recolor RGBYCP: Texture", 2D) = "white" {}
		[Toggle(_ENABLEINNEROUTLINE_ON)] _EnableInnerOutline("Enable Inner Outline", Float) = 0
		_InnerOutlineFade("Inner Outline: Fade", Range( 0 , 1)) = 1
		[HDR]_InnerOutlineColor("Inner Outline: Color", Color) = (11.98431,1.254902,1.254902,1)
		_InnerOutlineWidth("Inner Outline: Width", Float) = 0.02
		[Toggle(_INNEROUTLINEDISTORTIONTOGGLE_ON)] _InnerOutlineDistortionToggle("Inner Outline: Distortion Toggle", Float) = 0
		_InnerOutlineDistortionIntensity("Inner Outline: Distortion Intensity", Vector) = (0.01,0.01,0,0)
		_InnerOutlineNoiseScale("Inner Outline: Noise Scale", Vector) = (4,4,0,0)
		_InnerOutlineNoiseSpeed("Inner Outline: Noise Speed", Vector) = (0,0.1,0,0)
		[Toggle(_INNEROUTLINETEXTURETOGGLE_ON)] _InnerOutlineTextureToggle("Inner Outline: Texture Toggle", Float) = 0
		_InnerOutlineTintTexture("Inner Outline: Tint Texture", 2D) = "white" {}
		_InnerOutlineTextureSpeed("Inner Outline: Texture Speed", Vector) = (0.5,0,0,0)
		[Toggle(_INNEROUTLINEOUTLINEONLYTOGGLE_ON)] _InnerOutlineOutlineOnlyToggle("Inner Outline: Outline Only Toggle", Float) = 0
		[Toggle(_ENABLEOUTEROUTLINE_ON)] _EnableOuterOutline("Enable Outer Outline", Float) = 0
		_OuterOutlineFade("Outer Outline: Fade", Range( 0 , 1)) = 1
		[HDR]_OuterOutlineColor("Outer Outline: Color", Color) = (0,0,0,1)
		_OuterOutlineWidth("Outer Outline: Width", Float) = 0.04
		[Toggle(_OUTEROUTLINEDISTORTIONTOGGLE_ON)] _OuterOutlineDistortionToggle("Outer Outline: Distortion Toggle", Float) = 0
		_OuterOutlineDistortionIntensity("Outer Outline: Distortion Intensity", Vector) = (0.01,0.01,0,0)
		_OuterOutlineNoiseScale("Outer Outline: Noise Scale", Vector) = (4,4,0,0)
		_OuterOutlineNoiseSpeed("Outer Outline: Noise Speed", Vector) = (0,0.1,0,0)
		[Toggle(_OUTEROUTLINETEXTURETOGGLE_ON)] _OuterOutlineTextureToggle("Outer Outline: Texture Toggle", Float) = 0
		_OuterOutlineTintTexture("Outer Outline: Tint Texture", 2D) = "white" {}
		_OuterOutlineTextureSpeed("Outer Outline: Texture Speed", Vector) = (0.5,0,0,0)
		[Toggle(_OUTEROUTLINEOUTLINEONLYTOGGLE_ON)] _OuterOutlineOutlineOnlyToggle("Outer Outline: Outline Only Toggle", Float) = 0
		[Toggle(_ENABLEPIXELOUTLINE_ON)] _EnablePixelOutline("Enable Pixel Outline", Float) = 0
		_PixelOutlineFade("Pixel Outline: Fade", Range( 0 , 1)) = 1
		[HDR]_PixelOutlineColor("Pixel Outline: Color", Color) = (0,0,0,1)
		_PixelOutlineWidth("Pixel Outline: Width", Float) = 1
		[Toggle(_PIXELOUTLINETEXTURETOGGLE_ON)] _PixelOutlineTextureToggle("Pixel Outline: Texture Toggle", Float) = 0
		_PixelOutlineTintTexture("Pixel Outline: Tint Texture", 2D) = "white" {}
		_PixelOutlineTextureSpeed("Pixel Outline: Texture Speed", Vector) = (0.5,0,0,0)
		[Toggle(_PIXELOUTLINEOUTLINEONLYTOGGLE_ON)] _PixelOutlineOutlineOnlyToggle("Pixel Outline: Outline Only Toggle", Float) = 0
		[Toggle(_ENABLEADDHUE_ON)] _EnableAddHue("Enable Add Hue", Float) = 0
		_AddHueFade("Add Hue: Fade", Range( 0 , 1)) = 1
		_AddHueSpeed("Add Hue: Speed", Float) = 1
		_AddHueBrightness("Add Hue: Brightness", Float) = 2
		_AddHueSaturation("Add Hue: Saturation", Range( 0 , 1)) = 1
		_AddHueContrast("Add Hue: Contrast", Float) = 0.5
		[Toggle(_ADDHUEMASKTOGGLE_ON)] _AddHueMaskToggle("Add Hue: Mask Toggle", Float) = 0
		_AddHueMask("Add Hue: Mask", 2D) = "white" {}
		[Toggle(_ENABLEPINGPONGGLOW_ON)] _EnablePingPongGlow("Enable Ping-Pong Glow", Float) = 0
		_PingPongGlowFade("Ping-Pong Glow: Fade", Range( 0 , 1)) = 1
		[HDR]_PingPongGlowFrom("Ping-Pong Glow: From", Color) = (5.992157,0.1882353,0.1882353,0)
		[HDR]_PingPongGlowTo("Ping-Pong Glow: To", Color) = (0.1882353,0.1882353,5.992157,0)
		_PingPongGlowFrequency("Ping-Pong Glow: Frequency", Float) = 3
		_PingPongGlowContrast("Ping-Pong Glow: Contrast", Float) = 1
		[Toggle(_ENABLESHIFTHUE_ON)] _EnableShiftHue("Enable Shift Hue", Float) = 0
		_ShiftHueSpeed("Shift Hue: Speed", Float) = 0.5
		[Toggle(_ENABLEINKSPREAD_ON)] _EnableInkSpread("Enable Ink Spread", Float) = 0
		_InkSpreadFade("Ink Spread: Fade", Range( 0 , 1)) = 1
		[HDR]_InkSpreadColor("Ink Spread: Color", Color) = (8.47419,5.013525,0.08873497,0)
		_InkSpreadContrast("Ink Spread: Contrast", Float) = 2
		_InkSpreadDistance("Ink Spread: Distance", Float) = 3
		_InkSpreadPosition("Ink Spread: Position", Vector) = (0.5,-1,0,0)
		_InkSpreadWidth("Ink Spread: Width", Float) = 0.2
		_InkSpreadNoiseScale("Ink Spread: Noise Scale", Vector) = (0.4,0.4,0,0)
		_InkSpreadNoiseFactor("Ink Spread: Noise Factor", Float) = 0.5
		[Toggle(_ENABLEBLACKTINT_ON)] _EnableBlackTint("Enable Black Tint", Float) = 0
		_BlackTintFade("Black Tint: Fade", Range( 0 , 1)) = 1
		[HDR]_BlackTintColor("Black Tint: Color", Color) = (0,0,1,0)
		_BlackTintPower("Black Tint: Power", Float) = 4
		[Toggle(_ENABLESINEGLOW_ON)] _EnableSineGlow("Enable Sine Glow", Float) = 0
		_SineGlowFade("Sine Glow: Fade", Range( 0 , 1)) = 1
		[HDR]_SineGlowColor("Sine Glow: Color", Color) = (0,2.007843,2.996078,0)
		_SineGlowContrast("Sine Glow: Contrast", Float) = 1
		_SineGlowFrequency("Sine Glow: Frequency", Float) = 4
		_SineGlowMin("Sine Glow: Min", Float) = 0
		_SineGlowMax("Sine Glow: Max", Float) = 1
		[Toggle(_SINEGLOWMASKTOGGLE_ON)] _SineGlowMaskToggle("Sine Glow: Mask Toggle", Float) = 0
		_SineGlowMask("Sine Glow: Mask", 2D) = "white" {}
		[Toggle(_ENABLESPLITTONING_ON)] _EnableSplitToning("Enable Split Toning", Float) = 0
		_SplitToningFade("Split Toning: Fade", Range( 0 , 1)) = 1
		[HDR]_SplitToningHighlightsColor("Split Toning: Highlights Color", Color) = (1,0.1,0.1,0)
		[HDR]_SplitToningShadowsColor("Split Toning: Shadows Color", Color) = (0.1,0.4000002,1,0)
		_SplitToningContrast("Split Toning: Contrast", Float) = 1
		_SplitToningBalance("Split Toning: Balance", Float) = 1
		_SplitToningShift("Split Toning: Shift", Range( -1 , 1)) = 0
		[Toggle(_ENABLECOLORREPLACE_ON)] _EnableColorReplace("Enable Color Replace", Float) = 0
		_ColorReplaceFade("Color Replace: Fade", Range( 0 , 1)) = 1
		_ColorReplaceFromColor("Color Replace: From Color", Color) = (0,0,0,0)
		[HDR]_ColorReplaceToColor("Color Replace: To Color", Color) = (0,0,0.2,0)
		_ColorReplaceRange("Color Replace: Range", Float) = 0.05
		_ColorReplaceSmoothness("Color Replace: Smoothness", Float) = 0.1
		_ColorReplaceContrast("Color Replace: Contrast", Float) = 1
		[Toggle(_ENABLENEGATIVE_ON)] _EnableNegative("Enable Negative", Float) = 0
		_NegativeFade("Negative: Fade", Range( 0 , 1)) = 1
		[Toggle(_ENABLEHOLOGRAM_ON)] _EnableHologram("Enable Hologram", Float) = 0
		_HologramFade("Hologram: Fade", Range( 0 , 1)) = 1
		[HDR]_HologramTint("Hologram: Tint", Color) = (0.3137255,1.662745,2.996078,1)
		_HologramContrast("Hologram: Contrast", Float) = 1
		_HologramLineFrequency("Hologram: Line Frequency", Float) = 500
		_HologramLineGap("Hologram: Line Gap", Range( 0 , 5)) = 3
		_HologramLineSpeed("Hologram: Line Speed", Float) = 0.01
		_HologramMinAlpha("Hologram: Min Alpha", Range( 0 , 1)) = 0.2
		_HologramDistortionOffset("Hologram: Distortion Offset", Float) = 0.5
		_HologramDistortionSpeed("Hologram: Distortion Speed", Float) = 2
		_HologramDistortionDensity("Hologram: Distortion Density", Float) = 0.5
		_HologramDistortionScale("Hologram: Distortion Scale", Float) = 10
		[Toggle(_ENABLEGLITCH_ON)] _EnableGlitch("Enable Glitch", Float) = 0
		_GlitchFade("Glitch: Fade", Range( 0 , 1)) = 1
		_GlitchMaskMin("Glitch: Mask Min", Range( 0 , 1)) = 0.4
		_GlitchMaskScale("Glitch: Mask Scale", Vector) = (0,0.2,0,0)
		_GlitchMaskSpeed("Glitch: Mask Speed", Vector) = (0,4,0,0)
		_GlitchHueSpeed("Glitch: Hue Speed", Float) = 1
		_GlitchBrightness("Glitch: Brightness", Float) = 4
		_GlitchNoiseScale("Glitch: Noise Scale", Vector) = (0,3,0,0)
		_GlitchNoiseSpeed("Glitch: Noise Speed", Vector) = (0,1,0,0)
		_GlitchDistortion("Glitch: Distortion", Vector) = (0.1,0,0,0)
		_GlitchDistortionScale("Glitch: Distortion Scale", Vector) = (0,3,0,0)
		_GlitchDistortionSpeed("Glitch: Distortion Speed", Vector) = (0,1,0,0)
		[Toggle(_ENABLEFROZEN_ON)] _EnableFrozen("Enable Frozen", Float) = 0
		_FrozenFade("Frozen: Fade", Range( 0 , 1)) = 1
		[HDR]_FrozenTint("Frozen: Tint", Color) = (1.819608,4.611765,5.992157,0)
		_FrozenContrast("Frozen: Contrast", Float) = 2
		[HDR]_FrozenSnowColor("Frozen: Snow Color", Color) = (1.123529,1.373203,1.498039,0)
		_FrozenSnowContrast("Frozen: Snow Contrast", Float) = 1
		_FrozenSnowDensity("Frozen: Snow Density", Range( 0 , 1)) = 0.25
		_FrozenSnowScale("Frozen: Snow Scale", Vector) = (0.1,0.1,0,0)
		[HDR]_FrozenHighlightColor("Frozen: Highlight Color", Color) = (1.797647,4.604501,5.992157,1)
		_FrozenHighlightContrast("Frozen: Highlight Contrast", Float) = 2
		_FrozenHighlightDensity("Frozen: Highlight Density", Range( 0 , 1)) = 1
		_FrozenHighlightSpeed("Frozen: Highlight Speed", Vector) = (0.1,0.1,0,0)
		_FrozenHighlightScale("Frozen: Highlight Scale", Vector) = (0.2,0.2,0,0)
		_FrozenHighlightDistortion("Frozen: Highlight Distortion", Vector) = (0.5,0.5,0,0)
		_FrozenHighlightDistortionSpeed("Frozen: Highlight Distortion Speed", Vector) = (-0.05,-0.05,0,0)
		_FrozenHighlightDistortionScale("Frozen: Highlight Distortion Scale", Vector) = (0.2,0.2,0,0)
		[Toggle(_ENABLERAINBOW_ON)] _EnableRainbow("Enable Rainbow", Float) = 0
		_RainbowFade("Rainbow: Fade", Range( 0 , 1)) = 1
		_RainbowBrightness("Rainbow: Brightness", Float) = 2
		_RainbowSaturation("Rainbow: Saturation", Range( 0 , 1)) = 1
		_RainbowContrast("Rainbow: Contrast", Float) = 1
		_RainbowSpeed("Rainbow: Speed", Float) = 1
		_RainbowDensity("Rainbow: Density", Float) = 0.5
		_RainbowCenter("Rainbow: Center", Vector) = (0,0,0,0)
		_RainbowNoiseScale("Rainbow: Noise Scale", Vector) = (0.2,0.2,0,0)
		_RainbowNoiseFactor("Rainbow: Noise Factor", Float) = 0.2
		[Toggle(_ENABLECAMOUFLAGE_ON)] _EnableCamouflage("Enable Camouflage", Float) = 0
		_CamouflageFade("Camouflage: Fade", Range( 0 , 1)) = 1
		_CamouflageBaseColor("Camouflage: Base Color", Color) = (0.7450981,0.7254902,0.5686275,0)
		_CamouflageContrast("Camouflage: Contrast", Float) = 1
		_CamouflageColorA("Camouflage: Color A", Color) = (0.627451,0.5882353,0.4313726,0)
		_CamouflageDensityA("Camouflage: Density A", Range( 0 , 1)) = 0.4
		_CamouflageSmoothnessA("Camouflage: Smoothness A", Range( 0 , 1)) = 0.2
		_CamouflageNoiseScaleA("Camouflage: Noise Scale A", Vector) = (0.25,0.25,0,0)
		_CamouflageColorB("Camouflage: Color B", Color) = (0.4705882,0.4313726,0.3137255,0)
		_CamouflageDensityB("Camouflage: Density B", Range( 0 , 1)) = 0.4
		_CamouflageSmoothnessB("Camouflage: Smoothness B", Range( 0 , 1)) = 0.2
		_CamouflageNoiseScaleB("Camouflage: Noise Scale B", Vector) = (0.25,0.25,0,0)
		[Toggle(_CAMOUFLAGEANIMATIONTOGGLE_ON)] _CamouflageAnimationToggle("Camouflage: Animation Toggle", Float) = 0
		_CamouflageDistortionSpeed("Camouflage: Distortion Speed", Vector) = (0.1,0.1,0,0)
		_CamouflageDistortionIntensity("Camouflage: Distortion Intensity", Vector) = (0.1,0.1,0,0)
		_CamouflageDistortionScale("Camouflage: Distortion Scale", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLEMETAL_ON)] _EnableMetal("Enable Metal", Float) = 0
		_MetalFade("Metal: Fade", Range( 0 , 1)) = 1
		[HDR]_MetalColor("Metal: Color", Color) = (5.992157,3.639216,0.3137255,1)
		_MetalContrast("Metal: Contrast", Float) = 2
		[HDR]_MetalHighlightColor("Metal: Highlight Color", Color) = (5.992157,3.796078,0.6588235,1)
		_MetalHighlightDensity("Metal: Highlight Density", Range( 0 , 1)) = 1
		_MetalHighlightContrast("Metal: Highlight Contrast", Float) = 2
		_MetalNoiseScale("Metal: Noise Scale", Vector) = (0.25,0.25,0,0)
		_MetalNoiseSpeed("Metal: Noise Speed", Vector) = (0.05,0.05,0,0)
		_MetalNoiseDistortionScale("Metal: Noise Distortion Scale", Vector) = (0.2,0.2,0,0)
		_MetalNoiseDistortionSpeed("Metal: Noise Distortion Speed", Vector) = (-0.05,-0.05,0,0)
		_MetalNoiseDistortion("Metal: Noise Distortion", Vector) = (0.5,0.5,0,0)
		[Toggle(_METALMASKTOGGLE_ON)] _MetalMaskToggle("Metal: Mask Toggle", Float) = 0
		[NoScaleOffset]_MetalMask("Metal: Mask", 2D) = "white" {}
		[Toggle(_ENABLESHINE_ON)] _EnableShine("Enable Shine", Float) = 0
		_ShineFade("Shine: Fade", Range( 0 , 1)) = 1
		[HDR]_ShineColor("Shine: Color", Color) = (11.98431,11.98431,11.98431,0)
		_ShineSaturation("Shine: Saturation", Range( 0 , 1)) = 0.5
		_ShineContrast("Shine: Contrast", Float) = 2
		_ShineWidth("Shine: Width", Range( 0.001 , 1)) = 0.1
		_ShineSpeed("Shine: Speed", Float) = 5
		_ShineRotation("Shine: Rotation", Range( 0 , 360)) = 30
		_ShineFrequency("Shine: Frequency", Float) = 0.3
		[Toggle(_SHINEMASKTOGGLE_ON)] _ShineMaskToggle("Shine: Mask Toggle", Float) = 0
		[NoScaleOffset]_ShineMask("Shine: Mask", 2D) = "white" {}
		[Toggle(_ENABLEBURN_ON)] _EnableBurn("Enable Burn", Float) = 0
		_BurnFade("Burn: Fade", Range( 0 , 1)) = 1
		_BurnPosition("Burn: Position", Vector) = (0,5,0,0)
		_BurnRadius("Burn: Radius", Float) = 5
		[HDR]_BurnEdgeColor("Burn: Edge Color", Color) = (11.98431,1.129412,0.1254902,0)
		_BurnWidth("Burn: Width", Float) = 0.1
		_BurnEdgeNoiseScale("Burn: Edge Noise Scale", Vector) = (0.3,0.3,0,0)
		_BurnEdgeNoiseFactor("Burn: Edge Noise Factor", Float) = 0.5
		[HDR]_BurnInsideColor("Burn: Inside Color", Color) = (0.75,0.5625,0.525,0)
		_BurnInsideContrast("Burn: Inside Contrast", Float) = 2
		[HDR]_BurnInsideNoiseColor("Burn: Inside Noise Color", Color) = (3084.047,257.0039,0,0)
		_BurnInsideNoiseFactor("Burn: Inside Noise Factor", Float) = 0.2
		_BurnInsideNoiseScale("Burn: Inside Noise Scale", Vector) = (0.5,0.5,0,0)
		_BurnSwirlFactor("Burn: Swirl Factor", Float) = 1
		_BurnSwirlNoiseScale("Burn: Swirl Noise Scale", Vector) = (0.1,0.1,0,0)
		[Toggle(_ENABLEPOISON_ON)] _EnablePoison("Enable Poison", Float) = 0
		_PoisonFade("Poison: Fade", Range( 0 , 1)) = 1
		[HDR]_PoisonColor("Poison: Color", Color) = (0.3137255,2.996078,0.3137255,0)
		_PoisonDensity("Poison: Density", Float) = 3
		_PoisonRecolorFactor("Poison: Recolor Factor", Range( 0 , 1)) = 0.5
		_PoisonShiftSpeed("Poison: Shift Speed", Float) = 0.2
		_PoisonNoiseBrightness("Poison: Noise Brightness", Float) = 2
		_PoisonNoiseScale("Poison: Noise Scale", Vector) = (0.2,0.2,0,0)
		_PoisonNoiseSpeed("Poison: Noise Speed", Vector) = (0,-0.2,0,0)
		[Toggle(_ENABLEENCHANTED_ON)] _EnableEnchanted("Enable Enchanted", Float) = 0
		_EnchantedFade("Enchanted: Fade", Range( 0 , 1)) = 1
		_EnchantedSpeed("Enchanted: Speed", Vector) = (0,1,0,0)
		_EnchantedScale("Enchanted: Scale", Vector) = (0.1,0.1,0,0)
		_EnchantedBrightness("Enchanted: Brightness", Float) = 1
		_EnchantedContrast("Enchanted: Contrast", Float) = 0.5
		_EnchantedReduce("Enchanted: Reduce", Range( 0 , 2)) = 0
		[Toggle(_ENCHANTEDRAINBOWTOGGLE_ON)] _EnchantedRainbowToggle("Enchanted: Rainbow Toggle", Float) = 0
		_EnchantedRainbowSpeed("Enchanted: Rainbow Speed", Float) = 0.5
		_EnchantedRainbowDensity("Enchanted: Rainbow Density", Float) = 0.5
		_EnchantedRainbowSaturation("Enchanted: Rainbow Saturation", Float) = 0.8
		[HDR]_EnchantedLowColor("Enchanted: Low Color", Color) = (2.996078,0,0,0)
		[HDR]_EnchantedHighColor("Enchanted: High Color", Color) = (0,0.7098798,4.237095,0)
		[Toggle(_ENCHANTEDLERPTOGGLE_ON)] _EnchantedLerpToggle("Enchanted: Lerp Toggle", Float) = 0
		[Toggle(_ENABLESHIFTING_ON)] _EnableShifting("Enable Shifting", Float) = 0
		_ShiftingFade("Shifting: Fade", Range( 0 , 1)) = 1
		_ShiftingSpeed("Shifting: Speed", Float) = 0.5
		_ShiftingDensity("Shifting: Density", Float) = 1.5
		_ShiftingBrightness("Shifting: Brightness", Float) = 1
		_ShiftingContrast("Shifting: Contrast", Float) = 0.5
		[Toggle(_SHIFTINGRAINBOWTOGGLE_ON)] _ShiftingRainbowToggle("Shifting: Rainbow Toggle", Float) = 0
		_ShiftingSaturation("Shifting: Saturation", Float) = 0.8
		[HDR]_ShiftingColorA("Shifting: Color A", Color) = (1.498039,0,0,0)
		[HDR]_ShiftingColorB("Shifting: Color B", Color) = (1.498039,0.7490196,0,0)
		[Toggle(_ENABLEFULLALPHADISSOLVE_ON)] _EnableFullAlphaDissolve("Enable Full Alpha Dissolve", Float) = 0
		_FullAlphaDissolveFade("Full Alpha Dissolve: Fade", Range( 0 , 1)) = 0.5
		_FullAlphaDissolveWidth("Full Alpha Dissolve: Width", Float) = 0.5
		_FullAlphaDissolveNoiseScale("Full Alpha Dissolve: Noise Scale", Vector) = (0.1,0.1,0,0)
		[Toggle(_ENABLEFULLGLOWDISSOLVE_ON)] _EnableFullGlowDissolve("Enable Full Glow Dissolve", Float) = 0
		_FullGlowDissolveFade("Full Glow Dissolve: Fade", Range( 0 , 1)) = 0.5
		_FullGlowDissolveWidth("Full Glow Dissolve: Width", Float) = 0.5
		[HDR]_FullGlowDissolveEdgeColor("Full Glow Dissolve: Edge Color", Color) = (11.98431,0.627451,0.627451,0)
		_FullGlowDissolveNoiseScale("Full Glow Dissolve: Noise Scale", Vector) = (0.1,0.1,0,0)
		[Toggle(_ENABLESOURCEALPHADISSOLVE_ON)] _EnableSourceAlphaDissolve("Enable Source Alpha Dissolve", Float) = 0
		_SourceAlphaDissolveFade("Source Alpha Dissolve: Fade", Float) = 1
		_SourceAlphaDissolvePosition("Source Alpha Dissolve: Position", Vector) = (0,0,0,0)
		_SourceAlphaDissolveWidth("Source Alpha Dissolve: Width", Float) = 0.2
		_SourceAlphaDissolveNoiseScale("Source Alpha Dissolve: Noise Scale", Vector) = (0.3,0.3,0,0)
		_SourceAlphaDissolveNoiseFactor("Source Alpha Dissolve: Noise Factor", Float) = 0.2
		[Toggle]_SourceAlphaDissolveInvert("Source Alpha Dissolve: Invert", Float) = 0
		[Toggle(_ENABLESOURCEGLOWDISSOLVE_ON)] _EnableSourceGlowDissolve("Enable Source Glow Dissolve", Float) = 0
		_SourceGlowDissolveFade("Source Glow Dissolve: Fade", Float) = 1
		_SourceGlowDissolvePosition("Source Glow Dissolve: Position", Vector) = (0,0,0,0)
		_SourceGlowDissolveWidth("Source Glow Dissolve: Width", Float) = 0.1
		[HDR]_SourceGlowDissolveEdgeColor("Source Glow Dissolve: Edge Color", Color) = (11.98431,0.627451,0.627451,0)
		_SourceGlowDissolveNoiseScale("Source Glow Dissolve: Noise Scale", Vector) = (0.3,0.3,0,0)
		_SourceGlowDissolveNoiseFactor("Source Glow Dissolve: Noise Factor", Float) = 0.2
		[Toggle]_SourceGlowDissolveInvert("Source Glow Dissolve: Invert", Float) = 0
		[Toggle(_ENABLEHALFTONE_ON)] _EnableHalftone("Enable Halftone", Float) = 0
		_HalftoneFade("Halftone: Fade", Float) = 1
		_HalftonePosition("Halftone: Position", Vector) = (0,0,0,0)
		_HalftoneTiling("Halftone: Tiling", Float) = 4
		_HalftoneFadeWidth("Halftone: Width", Float) = 1.5
		[Toggle]_HalftoneInvert("Halftone: Invert", Float) = 0
		[Toggle(_ENABLEDIRECTIONALALPHAFADE_ON)] _EnableDirectionalAlphaFade("Enable Directional Alpha Fade", Float) = 0
		_DirectionalAlphaFadeFade("Directional Alpha Fade: Fade", Float) = 0
		_DirectionalAlphaFadeRotation("Directional Alpha Fade: Rotation", Range( 0 , 360)) = 0
		_DirectionalAlphaFadeWidth("Directional Alpha Fade: Width", Float) = 0.2
		_DirectionalAlphaFadeNoiseScale("Directional Alpha Fade: Noise Scale", Vector) = (0.3,0.3,0,0)
		_DirectionalAlphaFadeNoiseFactor("Directional Alpha Fade: Noise Factor", Float) = 0.2
		[Toggle]_DirectionalAlphaFadeInvert("Directional Alpha Fade: Invert", Float) = 0
		[Toggle(_ENABLEDIRECTIONALGLOWFADE_ON)] _EnableDirectionalGlowFade("Enable Directional Glow Fade", Float) = 0
		_DirectionalGlowFadeFade("Directional Glow Fade: Fade", Float) = 0
		_DirectionalGlowFadeRotation("Directional Glow Fade: Rotation", Range( 0 , 360)) = 0
		[HDR]_DirectionalGlowFadeEdgeColor("Directional Glow Fade: Edge Color", Color) = (11.98431,0.6901961,0.6901961,0)
		_DirectionalGlowFadeWidth("Directional Glow Fade: Width", Float) = 0.1
		_DirectionalGlowFadeNoiseScale("Directional Glow Fade: Noise Scale", Vector) = (0.4,0.4,0,0)
		_DirectionalGlowFadeNoiseFactor("Directional Glow Fade: Noise Factor", Float) = 0.2
		[Toggle]_DirectionalGlowFadeInvert("Directional Glow Fade: Invert", Float) = 0
		[Toggle(_ENABLEDIRECTIONALDISTORTION_ON)] _EnableDirectionalDistortion("Enable Directional Distortion", Float) = 0
		_DirectionalDistortionFade("Directional Distortion: Fade", Float) = 0
		_DirectionalDistortionRotation("Directional Distortion: Rotation", Range( 0 , 360)) = 0
		_DirectionalDistortionWidth("Directional Distortion: Width", Float) = 0.5
		_DirectionalDistortionNoiseScale("Directional Distortion: Noise Scale", Vector) = (0.4,0.4,0,0)
		_DirectionalDistortionNoiseFactor("Directional Distortion: Noise Factor", Float) = 0.2
		_DirectionalDistortionDistortion("Directional Distortion: Distortion", Vector) = (0,0.1,0,0)
		_DirectionalDistortionRandomDirection("Directional Distortion: Random Direction", Range( 0 , 1)) = 0.1
		_DirectionalDistortionDistortionScale("Directional Distortion: Distortion Scale", Vector) = (1,1,0,0)
		[Toggle]_DirectionalDistortionInvert("Directional Distortion: Invert", Float) = 0
		[Toggle(_ENABLEFULLDISTORTION_ON)] _EnableFullDistortion("Enable Full Distortion", Float) = 0
		_FullDistortionFade("Full Distortion: Fade", Range( 0 , 1)) = 1
		_FullDistortionDistortion("Full Distortion: Distortion", Vector) = (0.2,0.2,0,0)
		_FullDistortionNoiseScale("Full Distortion: Noise Scale", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLEPIXELATE_ON)] _EnablePixelate("Enable Pixelate", Float) = 0
		_PixelateFade("Pixelate: Fade", Range( 0 , 1)) = 1
		_PixelatePixelsPerUnit("Pixelate: Pixels Per Unit", Float) = 100
		_PixelatePixelDensity("Pixelate: Pixel Density", Float) = 16
		[Toggle(_ENABLESQUEEZE_ON)] _EnableSqueeze("Enable Squeeze", Float) = 0
		_SqueezeFade("Squeeze: Fade", Range( 0 , 1)) = 1
		_SqueezeScale("Squeeze: Scale", Vector) = (2,0,0,0)
		_SqueezePower("Squeeze: Power", Float) = 1
		_SqueezeCenter("Squeeze: Center", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLEUVDISTORT_ON)] _EnableUVDistort("Enable UV Distort", Float) = 0
		_UVDistortFade("UV Distort: Fade", Range( 0 , 1)) = 1
		_UVDistortFrom("UV Distort: From", Vector) = (-0.02,-0.02,0,0)
		_UVDistortTo("UV Distort: To", Vector) = (0.02,0.02,0,0)
		_UVDistortSpeed("UV Distort: Speed", Vector) = (2,2,0,0)
		_UVDistortNoiseScale("UV Distort: Noise Scale", Vector) = (0.1,0.1,0,0)
		[Toggle(_UVDISTORTMASKTOGGLE_ON)] _UVDistortMaskToggle("UV Distort: Mask Toggle", Float) = 0
		[NoScaleOffset]_UVDistortMask("UV Distort: Mask", 2D) = "white" {}
		[Toggle(_ENABLEUVSCROLL_ON)] _EnableUVScroll("Enable UV Scroll", Float) = 0
		_UVScrollSpeed("UV Scroll: Speed", Vector) = (0.2,0,0,0)
		[Toggle(_ENABLEUVROTATE_ON)] _EnableUVRotate("Enable UV Rotate", Float) = 0
		_UVRotateSpeed("UV Rotate: Speed", Float) = 1
		_UVRotatePivot("UV Rotate: Pivot", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLESINEROTATE_ON)] _EnableSineRotate("Enable Sine Rotate", Float) = 0
		_SineRotateFade("Sine Rotate: Fade", Range( 0 , 1)) = 1
		_SineRotateAngle("Sine Rotate: Angle", Float) = 15
		_SineRotateFrequency("Sine Rotate: Frequency", Float) = 1
		_SineRotatePivot("Sine Rotate: Pivot", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLEWIGGLE_ON)] _EnableWiggle("Enable Wiggle", Float) = 0
		_WiggleFade("Wiggle: Fade", Range( 0 , 1)) = 1
		_WiggleSpeed("Wiggle: Speed", Float) = 2
		_WiggleFrequency("Wiggle: Frequency", Float) = 2
		_WiggleOffset("Wiggle: Offset", Float) = 0.02
		[Toggle(_WIGGLEFIXEDGROUNDTOGGLE_ON)] _WiggleFixedGroundToggle("Wiggle: Fixed Ground Toggle", Float) = 0
		[Toggle(_ENABLEUVSCALE_ON)] _EnableUVScale("Enable UV Scale", Float) = 0
		_UVScaleScale("UV Scale: Scale", Vector) = (1,1,0,0)
		_UVScalePivot("UV Scale: Pivot", Vector) = (0.5,0.5,0,0)
		[Toggle(_ENABLESINEMOVE_ON)] _EnableSineMove("Enable Sine Move", Float) = 0
		_SineMoveFade("Sine Move: Fade", Range( 0 , 1)) = 1
		_SineMoveOffset("Sine Move: Offset", Vector) = (0,0.5,0,0)
		_SineMoveFrequency("Sine Move: Frequency", Vector) = (1,1,0,0)
		[Toggle(_ENABLESINESCALE_ON)] _EnableSineScale("Enable Sine Scale", Float) = 0
		_SineScaleFrequency("Sine Scale: Frequency", Float) = 2
		_SineScaleFactor("Sine Scale: Factor", Vector) = (0.2,0.2,0,0)
		[Toggle(_ENABLEVIBRATE_ON)] _EnableVibrate("Enable Vibrate", Float) = 0
		_VibrateFade("Vibrate: Fade", Range( 0 , 1)) = 1
		_VibrateOffset("Vibrate: Offset", Float) = 0.04
		_VibrateFrequency("Vibrate: Frequency", Float) = 100
		_VibrateRotation("Vibrate: Rotation", Float) = 4
		[Toggle(_ENABLEWIND_ON)] _EnableWind("Enable Wind", Float) = 0
		_WindRotation("Wind: Rotation", Float) = 0
		_WindMaxRotation("Wind: Max Rotation", Float) = 2
		_WindRotationWindFactor("Wind: Rotation Wind Factor", Float) = 1
		_WindSquishFactor("Wind: Squish Factor", Float) = 0.3
		_WindSquishWindFactor("Wind: Squish Wind Factor", Range( 0 , 1)) = 0
		[Toggle(_WINDLOCALWIND_ON)] _WindLocalWind("Wind: Local Wind", Float) = 0
		_WindNoiseScale("Wind: Noise Scale", Float) = 0.1
		_WindNoiseSpeed("Wind: Noise Speed", Float) = 1
		_WindMinIntensity("Wind: Min Intensity", Float) = -0.4
		_WindMaxIntensity("Wind: Max Intensity", Float) = 0.4
		[Toggle(_WINDHIGHQUALITYNOISE_ON)] _WindHighQualityNoise("Wind: High Quality Noise", Float) = 0
		[Toggle(_WINDISPARALLAX_ON)] _WindIsParallax("Wind: Is Parallax", Float) = 0
		_WindXPosition("Wind: X Position", Float) = 0
		_WindFlip("Wind: Flip", Float) = 0
		[Toggle(_ENABLESQUISH_ON)] _EnableSquish("Enable Squish", Float) = 0
		_SquishFade("Squish: Fade", Range( 0 , 1)) = 1
		_SquishStretch("Squish: Stretch", Float) = 0.1
		_SquishSquish("Squish: Squish", Float) = 0.1
		_SquishFlip("Squish: Flip", Range( -1 , 0)) = 0
		[Toggle(_ENABLECHECKERBOARD_ON)] _EnableCheckerboard("Enable Checkerboard", Float) = 0
		_CheckerboardDarken("Checkerboard: Darken", Range( 0 , 1)) = 0.5
		_CheckerboardTiling("Checkerboard: Tiling", Float) = 1
		[Toggle(_ENABLEFLAME_ON)] _EnableFlame("Enable Flame", Float) = 0
		_FlameBrightness("Flame: Brightness", Float) = 10
		_FlameSmooth("Flame: Smooth", Float) = 2
		_FlameRadius("Flame: Radius", Float) = 0.2
		_FlameSpeed("Flame: Speed", Vector) = (0,-0.5,0,0)
		_FlameNoiseFactor("Flame: Noise Factor", Float) = 2.5
		_FlameNoiseHeightFactor("Flame: Noise Height Factor", Float) = 1.5
		_FlameNoiseScale("Flame: Noise Scale", Vector) = (1.2,0.8,0,0)
		[Toggle(_ENABLEGAUSSIANBLUR_ON)] _EnableGaussianBlur("Enable Gaussian Blur", Float) = 0
		_GaussianBlurFade("Gaussian Blur: Fade", Range( 0 , 1)) = 1
		_GaussianBlurOffset("Gaussian Blur: Offset", Float) = 0.5
		[Toggle(_ENABLESHARPEN_ON)] _EnableSharpen("Enable Sharpen", Float) = 0
		_SharpenFade("Sharpen: Fade", Range( 0 , 1)) = 1
		_SharpenFactor("Sharpen: Factor", Float) = 4
		_SharpenOffset("Sharpen: Offset", Float) = 2
		[Toggle(_ENABLESMOOTHPIXELART_ON)] _EnableSmoothPixelArt("Enable Smooth Pixel Art", Float) = 0
		[Toggle(_ENABLESMOKE_ON)] _EnableSmoke("Enable Smoke", Float) = 0
		_SmokeAlpha("Smoke: Alpha", Range( 0 , 1)) = 1
		_SmokeSmoothness("Smoke: Smoothness", Float) = 1
		_SmokeNoiseScale("Smoke: Noise Scale", Float) = 0.5
		_SmokeNoiseFactor("Smoke: Noise Factor", Range( 0 , 1)) = 0.4
		_SmokeDarkEdge("Smoke: Dark Edge", Range( 0 , 1.5)) = 1
		[Toggle]_SmokeVertexSeed("Smoke: Vertex Seed", Float) = 0
		[Toggle(_ENABLECUSTOMFADE_ON)] _EnableCustomFade("Enable Custom Fade", Float) = 0
		_CustomFadeFadeMask("Custom Fade: Fade Mask", 2D) = "white" {}
		_CustomFadeSmoothness("Custom Fade: Smoothness", Float) = 2
		_CustomFadeNoiseScale("Custom Fade: Noise Scale", Vector) = (1,1,0,0)
		_CustomFadeNoiseFactor("Custom Fade: Noise Factor", Range( 0 , 0.5)) = 0
		_CustomFadeAlpha("Custom Fade: Alpha", Range( 0 , 1)) = 1
		[Toggle(_ENABLEWORLDTILING_ON)] _EnableWorldTiling("Enable World Tiling", Float) = 0
		_WorldTilingScale("World Tiling: Scale", Vector) = (1,1,0,0)
		_WorldTilingOffset("World Tiling: Offset", Vector) = (0,0,0,0)
		_WorldTilingPixelsPerUnit("World Tiling: Pixels Per Unit", Float) = 100
		[Toggle(_ENABLESCREENTILING_ON)] _EnableScreenTiling("Enable Screen Tiling", Float) = 0
		_ScreenTilingScale("Screen Tiling: Scale", Vector) = (1,1,0,0)
		_ScreenTilingOffset("Screen Tiling: Offset", Vector) = (0,0,0,0)
		[ASEEnd]_ScreenTilingPixelsPerUnit("Screen Tiling: Pixels Per Unit", Float) = 100
		[HideInInspector] _texcoord( "", 2D ) = "white" {}


		//_TransmissionShadow( "Transmission Shadow", Range( 0, 1 ) ) = 0.5
		//_TransStrength( "Trans Strength", Range( 0, 50 ) ) = 1
		//_TransNormal( "Trans Normal Distortion", Range( 0, 1 ) ) = 0.5
		//_TransScattering( "Trans Scattering", Range( 1, 50 ) ) = 2
		//_TransDirect( "Trans Direct", Range( 0, 1 ) ) = 0.9
		//_TransAmbient( "Trans Ambient", Range( 0, 1 ) ) = 0.1
		//_TransShadow( "Trans Shadow", Range( 0, 1 ) ) = 0.5
		//_TessPhongStrength( "Tess Phong Strength", Range( 0, 1 ) ) = 0.5
		//_TessValue( "Tess Max Tessellation", Range( 1, 32 ) ) = 16
		//_TessMin( "Tess Min Distance", Float ) = 10
		//_TessMax( "Tess Max Distance", Float ) = 25
		//_TessEdgeLength ( "Tess Edge length", Range( 2, 50 ) ) = 16
		//_TessMaxDisp( "Tess Max Displacement", Float ) = 25

		[HideInInspector][ToggleOff] _SpecularHighlights("Specular Highlights", Float) = 1.0
		[HideInInspector][ToggleOff] _EnvironmentReflections("Environment Reflections", Float) = 1.0
		[HideInInspector][ToggleOff] _ReceiveShadows("Receive Shadows", Float) = 1.0

		[HideInInspector] _QueueOffset("_QueueOffset", Float) = 0
        [HideInInspector] _QueueControl("_QueueControl", Float) = -1

        [HideInInspector][NoScaleOffset] unity_Lightmaps("unity_Lightmaps", 2DArray) = "" {}
        [HideInInspector][NoScaleOffset] unity_LightmapsInd("unity_LightmapsInd", 2DArray) = "" {}
        [HideInInspector][NoScaleOffset] unity_ShadowMasks("unity_ShadowMasks", 2DArray) = "" {}
	}

	SubShader
	{
		LOD 0

		

		Tags { "RenderPipeline"="UniversalPipeline" "RenderType"="Transparent" "Queue"="Transparent" "UniversalMaterialType"="Lit" }

		Cull Off
		ZWrite Off
		ZTest LEqual
		Offset 0 , 0
		AlphaToMask Off

		

		HLSLINCLUDE
		#pragma target 3.5
		#pragma prefer_hlslcc gles
		// ensure rendering platforms toggle list is visible

		#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Common.hlsl"
		#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Filtering.hlsl"

		#ifndef ASE_TESS_FUNCS
		#define ASE_TESS_FUNCS
		float4 FixedTess( float tessValue )
		{
			return tessValue;
		}

		float CalcDistanceTessFactor (float4 vertex, float minDist, float maxDist, float tess, float4x4 o2w, float3 cameraPos )
		{
			float3 wpos = mul(o2w,vertex).xyz;
			float dist = distance (wpos, cameraPos);
			float f = clamp(1.0 - (dist - minDist) / (maxDist - minDist), 0.01, 1.0) * tess;
			return f;
		}

		float4 CalcTriEdgeTessFactors (float3 triVertexFactors)
		{
			float4 tess;
			tess.x = 0.5 * (triVertexFactors.y + triVertexFactors.z);
			tess.y = 0.5 * (triVertexFactors.x + triVertexFactors.z);
			tess.z = 0.5 * (triVertexFactors.x + triVertexFactors.y);
			tess.w = (triVertexFactors.x + triVertexFactors.y + triVertexFactors.z) / 3.0f;
			return tess;
		}

		float CalcEdgeTessFactor (float3 wpos0, float3 wpos1, float edgeLen, float3 cameraPos, float4 scParams )
		{
			float dist = distance (0.5 * (wpos0+wpos1), cameraPos);
			float len = distance(wpos0, wpos1);
			float f = max(len * scParams.y / (edgeLen * dist), 1.0);
			return f;
		}

		float DistanceFromPlane (float3 pos, float4 plane)
		{
			float d = dot (float4(pos,1.0f), plane);
			return d;
		}

		bool WorldViewFrustumCull (float3 wpos0, float3 wpos1, float3 wpos2, float cullEps, float4 planes[6] )
		{
			float4 planeTest;
			planeTest.x = (( DistanceFromPlane(wpos0, planes[0]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos1, planes[0]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos2, planes[0]) > -cullEps) ? 1.0f : 0.0f );
			planeTest.y = (( DistanceFromPlane(wpos0, planes[1]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos1, planes[1]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos2, planes[1]) > -cullEps) ? 1.0f : 0.0f );
			planeTest.z = (( DistanceFromPlane(wpos0, planes[2]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos1, planes[2]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos2, planes[2]) > -cullEps) ? 1.0f : 0.0f );
			planeTest.w = (( DistanceFromPlane(wpos0, planes[3]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos1, planes[3]) > -cullEps) ? 1.0f : 0.0f ) +
							(( DistanceFromPlane(wpos2, planes[3]) > -cullEps) ? 1.0f : 0.0f );
			return !all (planeTest);
		}

		float4 DistanceBasedTess( float4 v0, float4 v1, float4 v2, float tess, float minDist, float maxDist, float4x4 o2w, float3 cameraPos )
		{
			float3 f;
			f.x = CalcDistanceTessFactor (v0,minDist,maxDist,tess,o2w,cameraPos);
			f.y = CalcDistanceTessFactor (v1,minDist,maxDist,tess,o2w,cameraPos);
			f.z = CalcDistanceTessFactor (v2,minDist,maxDist,tess,o2w,cameraPos);

			return CalcTriEdgeTessFactors (f);
		}

		float4 EdgeLengthBasedTess( float4 v0, float4 v1, float4 v2, float edgeLength, float4x4 o2w, float3 cameraPos, float4 scParams )
		{
			float3 pos0 = mul(o2w,v0).xyz;
			float3 pos1 = mul(o2w,v1).xyz;
			float3 pos2 = mul(o2w,v2).xyz;
			float4 tess;
			tess.x = CalcEdgeTessFactor (pos1, pos2, edgeLength, cameraPos, scParams);
			tess.y = CalcEdgeTessFactor (pos2, pos0, edgeLength, cameraPos, scParams);
			tess.z = CalcEdgeTessFactor (pos0, pos1, edgeLength, cameraPos, scParams);
			tess.w = (tess.x + tess.y + tess.z) / 3.0f;
			return tess;
		}

		float4 EdgeLengthBasedTessCull( float4 v0, float4 v1, float4 v2, float edgeLength, float maxDisplacement, float4x4 o2w, float3 cameraPos, float4 scParams, float4 planes[6] )
		{
			float3 pos0 = mul(o2w,v0).xyz;
			float3 pos1 = mul(o2w,v1).xyz;
			float3 pos2 = mul(o2w,v2).xyz;
			float4 tess;

			if (WorldViewFrustumCull(pos0, pos1, pos2, maxDisplacement, planes))
			{
				tess = 0.0f;
			}
			else
			{
				tess.x = CalcEdgeTessFactor (pos1, pos2, edgeLength, cameraPos, scParams);
				tess.y = CalcEdgeTessFactor (pos2, pos0, edgeLength, cameraPos, scParams);
				tess.z = CalcEdgeTessFactor (pos0, pos1, edgeLength, cameraPos, scParams);
				tess.w = (tess.x + tess.y + tess.z) / 3.0f;
			}
			return tess;
		}
		#endif //ASE_TESS_FUNCS
		ENDHLSL

		
		Pass
		{
			
			Name "Forward"
			Tags { "LightMode"="UniversalForward" }

			Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
			ZWrite Off
			ZTest LEqual
			Offset 0 , 0
			ColorMask RGBA

			

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#pragma multi_compile_instancing
			#pragma instancing_options renderinglayer
			#pragma multi_compile_fog
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma shader_feature_local _RECEIVE_SHADOWS_OFF
			#pragma shader_feature_local_fragment _SPECULARHIGHLIGHTS_OFF
			#pragma shader_feature_local_fragment _ENVIRONMENTREFLECTIONS_OFF

			#pragma multi_compile _ _MAIN_LIGHT_SHADOWS _MAIN_LIGHT_SHADOWS_CASCADE _MAIN_LIGHT_SHADOWS_SCREEN
			#pragma multi_compile _ _ADDITIONAL_LIGHTS_VERTEX _ADDITIONAL_LIGHTS
			#pragma multi_compile_fragment _ _ADDITIONAL_LIGHT_SHADOWS
			#pragma multi_compile_fragment _ _REFLECTION_PROBE_BLENDING
			#pragma multi_compile_fragment _ _REFLECTION_PROBE_BOX_PROJECTION
			#pragma multi_compile_fragment _ _SHADOWS_SOFT
			#pragma multi_compile_fragment _ _SCREEN_SPACE_OCCLUSION
			#pragma multi_compile_fragment _ _DBUFFER_MRT1 _DBUFFER_MRT2 _DBUFFER_MRT3
			#pragma multi_compile_fragment _ _LIGHT_LAYERS
			#pragma multi_compile_fragment _ _LIGHT_COOKIES
			#pragma multi_compile _ _CLUSTERED_RENDERING

			#pragma multi_compile _ LIGHTMAP_SHADOW_MIXING
			#pragma multi_compile _ SHADOWS_SHADOWMASK
			#pragma multi_compile _ DIRLIGHTMAP_COMBINED
			#pragma multi_compile _ LIGHTMAP_ON
			#pragma multi_compile _ DYNAMICLIGHTMAP_ON
			#pragma multi_compile_fragment _ DEBUG_DISPLAY

			#pragma vertex vert
			#pragma fragment frag

			#define SHADERPASS SHADERPASS_FORWARD

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Shadows.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/DBuffer.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#if defined(UNITY_INSTANCING_ENABLED) && defined(_TERRAIN_INSTANCED_PERPIXEL_NORMAL)
				#define ENABLE_TERRAIN_PERPIXEL_NORMAL
			#endif

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_SCREEN_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON
			#pragma shader_feature _EMISSIONTOGGLE_ON
			#pragma shader_feature _METALLICMAPTOGGLE_ON


			#if defined(ASE_EARLY_Z_DEPTH_OPTIMIZE) && (SHADER_TARGET >= 45)
				#define ASE_SV_DEPTH SV_DepthLessEqual
				#define ASE_SV_POSITION_QUALIFIERS linear noperspective centroid
			#else
				#define ASE_SV_DEPTH SV_Depth
				#define ASE_SV_POSITION_QUALIFIERS
			#endif

			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_tangent : TANGENT;
				float4 texcoord : TEXCOORD0;
				float4 texcoord1 : TEXCOORD1;
				float4 texcoord2 : TEXCOORD2;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				ASE_SV_POSITION_QUALIFIERS float4 clipPos : SV_POSITION;
				float4 clipPosV : TEXCOORD0;
				float4 lightmapUVOrVertexSH : TEXCOORD1;
				half4 fogFactorAndVertexLight : TEXCOORD2;
				float4 tSpace0 : TEXCOORD3;
				float4 tSpace1 : TEXCOORD4;
				float4 tSpace2 : TEXCOORD5;
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
					float4 shadowCoord : TEXCOORD6;
				#endif
				#if defined(DYNAMICLIGHTMAP_ON)
					float2 dynamicLightmapUV : TEXCOORD7;
				#endif
				float4 ase_texcoord8 : TEXCOORD8;
				float4 ase_texcoord9 : TEXCOORD9;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			#ifdef _EMISSIONTOGGLE_ON
			float4 _EmissionTint;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			#ifdef _ENABLEMETAL_ON
			sampler2D _MetalMask;
			#endif
			#ifdef _ENABLESHINE_ON
			sampler2D _ShineMask;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			sampler2D _StrongTintMask;
			sampler2D _NormalMap;
			#ifdef _EMISSIONTOGGLE_ON
			sampler2D _EmissionMap;
			#endif
			#ifdef _METALLICMAPTOGGLE_ON
			sampler2D _MetallicMap;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/PBRForwardPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			VertexOutput VertexFunction( VertexInput v  )
			{
				VertexOutput o = (VertexOutput)0;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.texcoord.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.texcoord.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord8.xy = v.texcoord.xy;
				o.ase_texcoord9 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord8.zw = 0;

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif
				v.ase_normal = v.ase_normal;

				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );
				float3 positionVS = TransformWorldToView( positionWS );
				float4 positionCS = TransformWorldToHClip( positionWS );

				VertexNormalInputs normalInput = GetVertexNormalInputs( v.ase_normal, v.ase_tangent );

				o.tSpace0 = float4( normalInput.normalWS, positionWS.x);
				o.tSpace1 = float4( normalInput.tangentWS, positionWS.y);
				o.tSpace2 = float4( normalInput.bitangentWS, positionWS.z);

				#if defined(LIGHTMAP_ON)
					OUTPUT_LIGHTMAP_UV( v.texcoord1, unity_LightmapST, o.lightmapUVOrVertexSH.xy );
				#endif

				#if !defined(LIGHTMAP_ON)
					OUTPUT_SH( normalInput.normalWS.xyz, o.lightmapUVOrVertexSH.xyz );
				#endif

				#if defined(DYNAMICLIGHTMAP_ON)
					o.dynamicLightmapUV.xy = v.texcoord2.xy * unity_DynamicLightmapST.xy + unity_DynamicLightmapST.zw;
				#endif

				#if defined(ENABLE_TERRAIN_PERPIXEL_NORMAL)
					o.lightmapUVOrVertexSH.zw = v.texcoord.xy;
					o.lightmapUVOrVertexSH.xy = v.texcoord.xy * unity_LightmapST.xy + unity_LightmapST.zw;
				#endif

				half3 vertexLight = VertexLighting( positionWS, normalInput.normalWS );

				#ifdef ASE_FOG
					half fogFactor = ComputeFogFactor( positionCS.z );
				#else
					half fogFactor = 0;
				#endif

				o.fogFactorAndVertexLight = half4(fogFactor, vertexLight);

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = positionCS;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				o.clipPos = positionCS;
				o.clipPosV = positionCS;
				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 ase_tangent : TANGENT;
				float4 texcoord : TEXCOORD0;
				float4 texcoord1 : TEXCOORD1;
				float4 texcoord2 : TEXCOORD2;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.ase_tangent = v.ase_tangent;
				o.texcoord = v.texcoord;
				o.texcoord1 = v.texcoord1;
				o.texcoord2 = v.texcoord2;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.ase_tangent = patch[0].ase_tangent * bary.x + patch[1].ase_tangent * bary.y + patch[2].ase_tangent * bary.z;
				o.texcoord = patch[0].texcoord * bary.x + patch[1].texcoord * bary.y + patch[2].texcoord * bary.z;
				o.texcoord1 = patch[0].texcoord1 * bary.x + patch[1].texcoord1 * bary.y + patch[2].texcoord1 * bary.z;
				o.texcoord2 = patch[0].texcoord2 * bary.x + patch[1].texcoord2 * bary.y + patch[2].texcoord2 * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag ( VertexOutput IN
						#ifdef ASE_DEPTH_WRITE_ON
						,out float outputDepth : ASE_SV_DEPTH
						#endif
						 ) : SV_Target
			{
				UNITY_SETUP_INSTANCE_ID(IN);
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX(IN);

				#ifdef LOD_FADE_CROSSFADE
					LODDitheringTransition( IN.clipPos.xyz, unity_LODFade.x );
				#endif

				#if defined(ENABLE_TERRAIN_PERPIXEL_NORMAL)
					float2 sampleCoords = (IN.lightmapUVOrVertexSH.zw / _TerrainHeightmapRecipSize.zw + 0.5f) * _TerrainHeightmapRecipSize.xy;
					float3 WorldNormal = TransformObjectToWorldNormal(normalize(SAMPLE_TEXTURE2D(_TerrainNormalmapTexture, sampler_TerrainNormalmapTexture, sampleCoords).rgb * 2 - 1));
					float3 WorldTangent = -cross(GetObjectToWorldMatrix()._13_23_33, WorldNormal);
					float3 WorldBiTangent = cross(WorldNormal, -WorldTangent);
				#else
					float3 WorldNormal = normalize( IN.tSpace0.xyz );
					float3 WorldTangent = IN.tSpace1.xyz;
					float3 WorldBiTangent = IN.tSpace2.xyz;
				#endif

				float3 WorldPosition = float3(IN.tSpace0.w,IN.tSpace1.w,IN.tSpace2.w);
				float3 WorldViewDirection = _WorldSpaceCameraPos.xyz  - WorldPosition;
				float4 ShadowCoords = float4( 0, 0, 0, 0 );

				float4 ClipPos = IN.clipPosV;
				float4 ScreenPos = ComputeScreenPos( IN.clipPosV );

				float2 NormalizedScreenSpaceUV = GetNormalizedScreenSpaceUV(IN.clipPos);

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
					ShadowCoords = IN.shadowCoord;
				#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
					ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
				#endif

				WorldViewDirection = SafeNormalize( WorldViewDirection );

				float2 texCoord363 = IN.ase_texcoord8.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_screenPosNorm = ScreenPos / ScreenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord8.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord8.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord9.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord9.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord8.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord8.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord8.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord8.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord8.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord8.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord8.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord8.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord8.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				
				float2 temp_output_11_0_g11881 = finalUV146;
				float3 unpack3_g11881 = UnpackNormalScale( tex2D( _NormalMap, temp_output_11_0_g11881 ), _NormalIntensity );
				unpack3_g11881.z = lerp( 1, unpack3_g11881.z, saturate(_NormalIntensity) );
				
				#ifdef _EMISSIONTOGGLE_ON
				float3 appendResult20_g11881 = (float3(_EmissionTint.r , _EmissionTint.g , _EmissionTint.b));
				float4 tex2DNode17_g11881 = tex2D( _EmissionMap, temp_output_11_0_g11881 );
				float3 appendResult18_g11881 = (float3(tex2DNode17_g11881.r , tex2DNode17_g11881.g , tex2DNode17_g11881.b));
				float3 staticSwitch13_g11881 = ( appendResult20_g11881 * appendResult18_g11881 * tex2DNode17_g11881.a );
				#else
				float3 staticSwitch13_g11881 = float3(0,0,0);
				#endif
				
				#ifdef _METALLICMAPTOGGLE_ON
				float4 tex2DNode7_g11881 = tex2D( _MetallicMap, temp_output_11_0_g11881 );
				float staticSwitch23_g11881 = ( tex2DNode7_g11881.r * _Metallic );
				#else
				float staticSwitch23_g11881 = _Metallic;
				#endif
				
				#ifdef _METALLICMAPTOGGLE_ON
				float staticSwitch22_g11881 = ( _Smoothness * tex2DNode7_g11881.r );
				#else
				float staticSwitch22_g11881 = _Smoothness;
				#endif
				

				float3 BaseColor = temp_output_340_0.rgb;
				float3 Normal = unpack3_g11881;
				float3 Emission = staticSwitch13_g11881;
				float3 Specular = 0.5;
				float Metallic = staticSwitch23_g11881;
				float Smoothness = staticSwitch22_g11881;
				float Occlusion = 1;
				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;
				float AlphaClipThresholdShadow = _ShadowClip;
				float3 BakedGI = 0;
				float3 RefractionColor = 1;
				float RefractionIndex = 1;
				float3 Transmission = 1;
				float3 Translucency = 1;

				#ifdef ASE_DEPTH_WRITE_ON
					float DepthValue = IN.clipPos.z;
				#endif

				#ifdef _CLEARCOAT
					float CoatMask = 0;
					float CoatSmoothness = 0;
				#endif

				#ifdef _ALPHATEST_ON
					clip(Alpha - AlphaClipThreshold);
				#endif

				InputData inputData = (InputData)0;
				inputData.positionWS = WorldPosition;
				inputData.viewDirectionWS = WorldViewDirection;

				#ifdef _NORMALMAP
						#if _NORMAL_DROPOFF_TS
							inputData.normalWS = TransformTangentToWorld(Normal, half3x3(WorldTangent, WorldBiTangent, WorldNormal));
						#elif _NORMAL_DROPOFF_OS
							inputData.normalWS = TransformObjectToWorldNormal(Normal);
						#elif _NORMAL_DROPOFF_WS
							inputData.normalWS = Normal;
						#endif
					inputData.normalWS = NormalizeNormalPerPixel(inputData.normalWS);
				#else
					inputData.normalWS = WorldNormal;
				#endif

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
					inputData.shadowCoord = ShadowCoords;
				#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
					inputData.shadowCoord = TransformWorldToShadowCoord(inputData.positionWS);
				#else
					inputData.shadowCoord = float4(0, 0, 0, 0);
				#endif

				#ifdef ASE_FOG
					inputData.fogCoord = IN.fogFactorAndVertexLight.x;
				#endif
					inputData.vertexLighting = IN.fogFactorAndVertexLight.yzw;

				#if defined(ENABLE_TERRAIN_PERPIXEL_NORMAL)
					float3 SH = SampleSH(inputData.normalWS.xyz);
				#else
					float3 SH = IN.lightmapUVOrVertexSH.xyz;
				#endif

				#if defined(DYNAMICLIGHTMAP_ON)
					inputData.bakedGI = SAMPLE_GI(IN.lightmapUVOrVertexSH.xy, IN.dynamicLightmapUV.xy, SH, inputData.normalWS);
				#else
					inputData.bakedGI = SAMPLE_GI(IN.lightmapUVOrVertexSH.xy, SH, inputData.normalWS);
				#endif

				#ifdef ASE_BAKEDGI
					inputData.bakedGI = BakedGI;
				#endif

				inputData.normalizedScreenSpaceUV = NormalizedScreenSpaceUV;
				inputData.shadowMask = SAMPLE_SHADOWMASK(IN.lightmapUVOrVertexSH.xy);

				#if defined(DEBUG_DISPLAY)
					#if defined(DYNAMICLIGHTMAP_ON)
						inputData.dynamicLightmapUV = IN.dynamicLightmapUV.xy;
					#endif
					#if defined(LIGHTMAP_ON)
						inputData.staticLightmapUV = IN.lightmapUVOrVertexSH.xy;
					#else
						inputData.vertexSH = SH;
					#endif
				#endif

				SurfaceData surfaceData;
				surfaceData.albedo              = BaseColor;
				surfaceData.metallic            = saturate(Metallic);
				surfaceData.specular            = Specular;
				surfaceData.smoothness          = saturate(Smoothness),
				surfaceData.occlusion           = Occlusion,
				surfaceData.emission            = Emission,
				surfaceData.alpha               = saturate(Alpha);
				surfaceData.normalTS            = Normal;
				surfaceData.clearCoatMask       = 0;
				surfaceData.clearCoatSmoothness = 1;

				#ifdef _CLEARCOAT
					surfaceData.clearCoatMask       = saturate(CoatMask);
					surfaceData.clearCoatSmoothness = saturate(CoatSmoothness);
				#endif

				#ifdef _DBUFFER
					ApplyDecalToSurfaceData(IN.clipPos, surfaceData, inputData);
				#endif

				half4 color = UniversalFragmentPBR( inputData, surfaceData);

				#ifdef ASE_TRANSMISSION
				{
					float shadow = _TransmissionShadow;

					Light mainLight = GetMainLight( inputData.shadowCoord );
					float3 mainAtten = mainLight.color * mainLight.distanceAttenuation;
					mainAtten = lerp( mainAtten, mainAtten * mainLight.shadowAttenuation, shadow );
					half3 mainTransmission = max(0 , -dot(inputData.normalWS, mainLight.direction)) * mainAtten * Transmission;
					color.rgb += BaseColor * mainTransmission;

					#ifdef _ADDITIONAL_LIGHTS
						int transPixelLightCount = GetAdditionalLightsCount();
						for (int i = 0; i < transPixelLightCount; ++i)
						{
							Light light = GetAdditionalLight(i, inputData.positionWS);
							float3 atten = light.color * light.distanceAttenuation;
							atten = lerp( atten, atten * light.shadowAttenuation, shadow );

							half3 transmission = max(0 , -dot(inputData.normalWS, light.direction)) * atten * Transmission;
							color.rgb += BaseColor * transmission;
						}
					#endif
				}
				#endif

				#ifdef ASE_TRANSLUCENCY
				{
					float shadow = _TransShadow;
					float normal = _TransNormal;
					float scattering = _TransScattering;
					float direct = _TransDirect;
					float ambient = _TransAmbient;
					float strength = _TransStrength;

					Light mainLight = GetMainLight( inputData.shadowCoord );
					float3 mainAtten = mainLight.color * mainLight.distanceAttenuation;
					mainAtten = lerp( mainAtten, mainAtten * mainLight.shadowAttenuation, shadow );

					half3 mainLightDir = mainLight.direction + inputData.normalWS * normal;
					half mainVdotL = pow( saturate( dot( inputData.viewDirectionWS, -mainLightDir ) ), scattering );
					half3 mainTranslucency = mainAtten * ( mainVdotL * direct + inputData.bakedGI * ambient ) * Translucency;
					color.rgb += BaseColor * mainTranslucency * strength;

					#ifdef _ADDITIONAL_LIGHTS
						int transPixelLightCount = GetAdditionalLightsCount();
						for (int i = 0; i < transPixelLightCount; ++i)
						{
							Light light = GetAdditionalLight(i, inputData.positionWS);
							float3 atten = light.color * light.distanceAttenuation;
							atten = lerp( atten, atten * light.shadowAttenuation, shadow );

							half3 lightDir = light.direction + inputData.normalWS * normal;
							half VdotL = pow( saturate( dot( inputData.viewDirectionWS, -lightDir ) ), scattering );
							half3 translucency = atten * ( VdotL * direct + inputData.bakedGI * ambient ) * Translucency;
							color.rgb += BaseColor * translucency * strength;
						}
					#endif
				}
				#endif

				#ifdef ASE_REFRACTION
					float4 projScreenPos = ScreenPos / ScreenPos.w;
					float3 refractionOffset = ( RefractionIndex - 1.0 ) * mul( UNITY_MATRIX_V, float4( WorldNormal,0 ) ).xyz * ( 1.0 - dot( WorldNormal, WorldViewDirection ) );
					projScreenPos.xy += refractionOffset.xy;
					float3 refraction = SHADERGRAPH_SAMPLE_SCENE_COLOR( projScreenPos.xy ) * RefractionColor;
					color.rgb = lerp( refraction, color.rgb, color.a );
					color.a = 1;
				#endif

				#ifdef ASE_FINAL_COLOR_ALPHA_MULTIPLY
					color.rgb *= color.a;
				#endif

				#ifdef ASE_FOG
					#ifdef TERRAIN_SPLAT_ADDPASS
						color.rgb = MixFogColor(color.rgb, half3( 0, 0, 0 ), IN.fogFactorAndVertexLight.x );
					#else
						color.rgb = MixFog(color.rgb, IN.fogFactorAndVertexLight.x);
					#endif
				#endif

				#ifdef ASE_DEPTH_WRITE_ON
					outputDepth = DepthValue;
				#endif

				return color;
			}

			ENDHLSL
		}

		
		Pass
		{
			
			Name "ShadowCaster"
			Tags { "LightMode"="ShadowCaster" }

			ZWrite On
			ZTest LEqual
			AlphaToMask Off
			ColorMask 0

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#pragma multi_compile_instancing
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma vertex vert
			#pragma fragment frag

			#pragma multi_compile_vertex _ _CASTING_PUNCTUAL_LIGHT_SHADOW

			#define SHADERPASS SHADERPASS_SHADOWCASTER

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_SCREEN_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON


			#if defined(ASE_EARLY_Z_DEPTH_OPTIMIZE) && (SHADER_TARGET >= 45)
				#define ASE_SV_DEPTH SV_DepthLessEqual
				#define ASE_SV_POSITION_QUALIFIERS linear noperspective centroid
			#else
				#define ASE_SV_DEPTH SV_Depth
				#define ASE_SV_POSITION_QUALIFIERS
			#endif

			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				ASE_SV_POSITION_QUALIFIERS float4 clipPos : SV_POSITION;
				float4 clipPosV : TEXCOORD0;
				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 worldPos : TEXCOORD1;
				#endif
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					float4 shadowCoord : TEXCOORD2;
				#endif				
				float4 ase_texcoord3 : TEXCOORD3;
				float4 ase_texcoord4 : TEXCOORD4;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			float4 _EmissionTint;
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			sampler2D _MetalMask;
			sampler2D _ShineMask;
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShadowCasterPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			float3 _LightDirection;
			float3 _LightPosition;

			VertexOutput VertexFunction( VertexInput v )
			{
				VertexOutput o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO( o );

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.ase_texcoord.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord3.xy = v.ase_texcoord.xy;
				o.ase_texcoord4 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord3.zw = 0;

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );
				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif

				v.ase_normal = v.ase_normal;

				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					o.worldPos = positionWS;
				#endif

				float3 normalWS = TransformObjectToWorldDir(v.ase_normal);

				#if _CASTING_PUNCTUAL_LIGHT_SHADOW
					float3 lightDirectionWS = normalize(_LightPosition - positionWS);
				#else
					float3 lightDirectionWS = _LightDirection;
				#endif

				float4 clipPos = TransformWorldToHClip(ApplyShadowBias(positionWS, normalWS, lightDirectionWS));

				#if UNITY_REVERSED_Z
					clipPos.z = min(clipPos.z, UNITY_NEAR_CLIP_VALUE);
				#else
					clipPos.z = max(clipPos.z, UNITY_NEAR_CLIP_VALUE);
				#endif

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = clipPos;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				o.clipPos = clipPos;
				o.clipPosV = clipPos;
				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.ase_texcoord = v.ase_texcoord;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.ase_texcoord = patch[0].ase_texcoord * bary.x + patch[1].ase_texcoord * bary.y + patch[2].ase_texcoord * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag(	VertexOutput IN
						#ifdef ASE_DEPTH_WRITE_ON
						,out float outputDepth : ASE_SV_DEPTH
						#endif
						 ) : SV_TARGET
			{
				UNITY_SETUP_INSTANCE_ID( IN );
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX( IN );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 WorldPosition = IN.worldPos;
				#endif

				float4 ShadowCoords = float4( 0, 0, 0, 0 );
				float4 ClipPos = IN.clipPosV;
				float4 ScreenPos = ComputeScreenPos( IN.clipPosV );

				#if defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
						ShadowCoords = IN.shadowCoord;
					#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
						ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
					#endif
				#endif

				float2 texCoord363 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_screenPosNorm = ScreenPos / ScreenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord4.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord4.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord3.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord3.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord3.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord3.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord3.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord3.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord3.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord3.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				

				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;
				float AlphaClipThresholdShadow = _ShadowClip;

				#ifdef ASE_DEPTH_WRITE_ON
					float DepthValue = IN.clipPos.z;
				#endif

					#ifdef _ALPHATEST_SHADOW_ON
				#ifdef _ALPHATEST_ON
						clip(Alpha - AlphaClipThresholdShadow);
					#else
						clip(Alpha - AlphaClipThreshold);
					#endif
				#endif

				#ifdef LOD_FADE_CROSSFADE
					LODDitheringTransition( IN.clipPos.xyz, unity_LODFade.x );
				#endif

				#ifdef ASE_DEPTH_WRITE_ON
					outputDepth = DepthValue;
				#endif

				return 0;
			}
			ENDHLSL
		}

		
		Pass
		{
			
			Name "DepthOnly"
			Tags { "LightMode"="DepthOnly" }

			ZWrite On
			ColorMask 0
			AlphaToMask Off

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#pragma multi_compile_instancing
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma vertex vert
			#pragma fragment frag

			#define SHADERPASS SHADERPASS_DEPTHONLY

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_SCREEN_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON


			#if defined(ASE_EARLY_Z_DEPTH_OPTIMIZE) && (SHADER_TARGET >= 45)
				#define ASE_SV_DEPTH SV_DepthLessEqual
				#define ASE_SV_POSITION_QUALIFIERS linear noperspective centroid
			#else
				#define ASE_SV_DEPTH SV_Depth
				#define ASE_SV_POSITION_QUALIFIERS
			#endif

			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				ASE_SV_POSITION_QUALIFIERS float4 clipPos : SV_POSITION;
				float4 clipPosV : TEXCOORD0;
				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
				float3 worldPos : TEXCOORD1;
				#endif
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
				float4 shadowCoord : TEXCOORD2;
				#endif
				float4 ase_texcoord3 : TEXCOORD3;
				float4 ase_texcoord4 : TEXCOORD4;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			float4 _EmissionTint;
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			sampler2D _MetalMask;
			sampler2D _ShineMask;
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/DepthOnlyPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			VertexOutput VertexFunction( VertexInput v  )
			{
				VertexOutput o = (VertexOutput)0;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.ase_texcoord.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord3.xy = v.ase_texcoord.xy;
				o.ase_texcoord4 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord3.zw = 0;

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif

				v.ase_normal = v.ase_normal;
				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );
				float4 positionCS = TransformWorldToHClip( positionWS );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					o.worldPos = positionWS;
				#endif

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = positionCS;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				o.clipPos = positionCS;
				o.clipPosV = positionCS;
				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.ase_texcoord = v.ase_texcoord;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.ase_texcoord = patch[0].ase_texcoord * bary.x + patch[1].ase_texcoord * bary.y + patch[2].ase_texcoord * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag(	VertexOutput IN
						#ifdef ASE_DEPTH_WRITE_ON
						,out float outputDepth : ASE_SV_DEPTH
						#endif
						 ) : SV_TARGET
			{
				UNITY_SETUP_INSTANCE_ID(IN);
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX( IN );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
				float3 WorldPosition = IN.worldPos;
				#endif

				float4 ShadowCoords = float4( 0, 0, 0, 0 );
				float4 ClipPos = IN.clipPosV;
				float4 ScreenPos = ComputeScreenPos( IN.clipPosV );

				#if defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
						ShadowCoords = IN.shadowCoord;
					#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
						ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
					#endif
				#endif

				float2 texCoord363 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_screenPosNorm = ScreenPos / ScreenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord4.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord4.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord3.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord3.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord3.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord3.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord3.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord3.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord3.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord3.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord3.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				

				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;
				#ifdef ASE_DEPTH_WRITE_ON
					float DepthValue = IN.clipPos.z;
				#endif

				#ifdef _ALPHATEST_ON
					clip(Alpha - AlphaClipThreshold);
				#endif

				#ifdef LOD_FADE_CROSSFADE
					LODDitheringTransition( IN.clipPos.xyz, unity_LODFade.x );
				#endif

				#ifdef ASE_DEPTH_WRITE_ON
					outputDepth = DepthValue;
				#endif

				return 0;
			}
			ENDHLSL
		}

		
		Pass
		{
			
			Name "Meta"
			Tags { "LightMode"="Meta" }

			Cull Off

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma vertex vert
			#pragma fragment frag

			#pragma shader_feature EDITOR_VISUALIZATION

			#define SHADERPASS SHADERPASS_META

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/MetaInput.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON
			#pragma shader_feature _EMISSIONTOGGLE_ON


			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 texcoord0 : TEXCOORD0;
				float4 texcoord1 : TEXCOORD1;
				float4 texcoord2 : TEXCOORD2;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				float4 clipPos : SV_POSITION;
				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 worldPos : TEXCOORD0;
				#endif
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					float4 shadowCoord : TEXCOORD1;
				#endif
				#ifdef EDITOR_VISUALIZATION
					float4 VizUV : TEXCOORD2;
					float4 LightCoord : TEXCOORD3;
				#endif
				float4 ase_texcoord4 : TEXCOORD4;
				float4 ase_texcoord5 : TEXCOORD5;
				float4 ase_texcoord6 : TEXCOORD6;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			#ifdef _EMISSIONTOGGLE_ON
			float4 _EmissionTint;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			#ifdef _ENABLEMETAL_ON
			sampler2D _MetalMask;
			#endif
			sampler2D _ShineMask;
			sampler2D _AddColorMask;
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif
			#ifdef _EMISSIONTOGGLE_ON
			sampler2D _EmissionMap;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/LightingMetaPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			VertexOutput VertexFunction( VertexInput v  )
			{
				VertexOutput o = (VertexOutput)0;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.texcoord0.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.texcoord0.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.texcoord0.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.texcoord0.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord5 = screenPos;
				
				o.ase_texcoord4.xy = v.texcoord0.xy;
				o.ase_texcoord6 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord4.zw = 0;

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif

				v.ase_normal = v.ase_normal;

				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					o.worldPos = positionWS;
				#endif

				o.clipPos = MetaVertexPosition( v.vertex, v.texcoord1.xy, v.texcoord1.xy, unity_LightmapST, unity_DynamicLightmapST );

				#ifdef EDITOR_VISUALIZATION
					float2 VizUV = 0;
					float4 LightCoord = 0;
					UnityEditorVizData(v.vertex.xyz, v.texcoord0.xy, v.texcoord1.xy, v.texcoord2.xy, VizUV, LightCoord);
					o.VizUV = float4(VizUV, 0, 0);
					o.LightCoord = LightCoord;
				#endif

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = o.clipPos;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 texcoord0 : TEXCOORD0;
				float4 texcoord1 : TEXCOORD1;
				float4 texcoord2 : TEXCOORD2;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.texcoord0 = v.texcoord0;
				o.texcoord1 = v.texcoord1;
				o.texcoord2 = v.texcoord2;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.texcoord0 = patch[0].texcoord0 * bary.x + patch[1].texcoord0 * bary.y + patch[2].texcoord0 * bary.z;
				o.texcoord1 = patch[0].texcoord1 * bary.x + patch[1].texcoord1 * bary.y + patch[2].texcoord1 * bary.z;
				o.texcoord2 = patch[0].texcoord2 * bary.x + patch[1].texcoord2 * bary.y + patch[2].texcoord2 * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag(VertexOutput IN  ) : SV_TARGET
			{
				UNITY_SETUP_INSTANCE_ID(IN);
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX( IN );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 WorldPosition = IN.worldPos;
				#endif

				float4 ShadowCoords = float4( 0, 0, 0, 0 );

				#if defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
						ShadowCoords = IN.shadowCoord;
					#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
						ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
					#endif
				#endif

				float2 texCoord363 = IN.ase_texcoord4.xy * float2( 1,1 ) + float2( 0,0 );
				float4 screenPos = IN.ase_texcoord5;
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord4.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord4.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord6.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord6.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord4.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord4.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord4.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord4.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord4.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord4.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord4.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord4.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord4.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				
				#ifdef _EMISSIONTOGGLE_ON
				float3 appendResult20_g11881 = (float3(_EmissionTint.r , _EmissionTint.g , _EmissionTint.b));
				float2 temp_output_11_0_g11881 = finalUV146;
				float4 tex2DNode17_g11881 = tex2D( _EmissionMap, temp_output_11_0_g11881 );
				float3 appendResult18_g11881 = (float3(tex2DNode17_g11881.r , tex2DNode17_g11881.g , tex2DNode17_g11881.b));
				float3 staticSwitch13_g11881 = ( appendResult20_g11881 * appendResult18_g11881 * tex2DNode17_g11881.a );
				#else
				float3 staticSwitch13_g11881 = float3(0,0,0);
				#endif
				

				float3 BaseColor = temp_output_340_0.rgb;
				float3 Emission = staticSwitch13_g11881;
				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;

				#ifdef _ALPHATEST_ON
					clip(Alpha - AlphaClipThreshold);
				#endif

				MetaInput metaInput = (MetaInput)0;
				metaInput.Albedo = BaseColor;
				metaInput.Emission = Emission;
				#ifdef EDITOR_VISUALIZATION
					metaInput.VizUV = IN.VizUV.xy;
					metaInput.LightCoord = IN.LightCoord;
				#endif

				return UnityMetaFragment(metaInput);
			}
			ENDHLSL
		}

		
		Pass
		{
			
			Name "Universal2D"
			Tags { "LightMode"="Universal2D" }

			Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
			ZWrite On
			ZTest LEqual
			Offset 0 , 0
			ColorMask RGBA

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma vertex vert
			#pragma fragment frag

			#define SHADERPASS SHADERPASS_2D

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON


			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				float4 clipPos : SV_POSITION;
				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 worldPos : TEXCOORD0;
				#endif
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					float4 shadowCoord : TEXCOORD1;
				#endif
				float4 ase_texcoord2 : TEXCOORD2;
				float4 ase_texcoord3 : TEXCOORD3;
				float4 ase_texcoord4 : TEXCOORD4;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			float4 _EmissionTint;
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			sampler2D _MetalMask;
			sampler2D _ShineMask;
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/PBR2DPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			VertexOutput VertexFunction( VertexInput v  )
			{
				VertexOutput o = (VertexOutput)0;
				UNITY_SETUP_INSTANCE_ID( v );
				UNITY_TRANSFER_INSTANCE_ID( v, o );
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO( o );

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.ase_texcoord.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord3 = screenPos;
				
				o.ase_texcoord2.xy = v.ase_texcoord.xy;
				o.ase_texcoord4 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord2.zw = 0;

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif

				v.ase_normal = v.ase_normal;

				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );
				float4 positionCS = TransformWorldToHClip( positionWS );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					o.worldPos = positionWS;
				#endif

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = positionCS;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				o.clipPos = positionCS;

				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.ase_texcoord = v.ase_texcoord;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.ase_texcoord = patch[0].ase_texcoord * bary.x + patch[1].ase_texcoord * bary.y + patch[2].ase_texcoord * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag(VertexOutput IN  ) : SV_TARGET
			{
				UNITY_SETUP_INSTANCE_ID( IN );
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX( IN );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 WorldPosition = IN.worldPos;
				#endif

				float4 ShadowCoords = float4( 0, 0, 0, 0 );

				#if defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
						ShadowCoords = IN.shadowCoord;
					#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
						ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
					#endif
				#endif

				float2 texCoord363 = IN.ase_texcoord2.xy * float2( 1,1 ) + float2( 0,0 );
				float4 screenPos = IN.ase_texcoord3;
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord2.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord2.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord4.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord4.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord2.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord2.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord2.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord2.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord2.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord2.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord2.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord2.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord2.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				

				float3 BaseColor = temp_output_340_0.rgb;
				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;

				half4 color = half4(BaseColor, Alpha );

				#ifdef _ALPHATEST_ON
					clip(Alpha - AlphaClipThreshold);
				#endif

				return color;
			}
			ENDHLSL
		}

		
		Pass
		{
			
			Name "DepthNormals"
			Tags { "LightMode"="DepthNormals" }

			ZWrite On
			Blend One Zero
			ZTest LEqual
			ZWrite On

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#pragma multi_compile_instancing
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma vertex vert
			#pragma fragment frag

			#define SHADERPASS SHADERPASS_DEPTHNORMALSONLY

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_SCREEN_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON


			#if defined(ASE_EARLY_Z_DEPTH_OPTIMIZE) && (SHADER_TARGET >= 45)
				#define ASE_SV_DEPTH SV_DepthLessEqual
				#define ASE_SV_POSITION_QUALIFIERS linear noperspective centroid
			#else
				#define ASE_SV_DEPTH SV_Depth
				#define ASE_SV_POSITION_QUALIFIERS
			#endif

			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_tangent : TANGENT;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				ASE_SV_POSITION_QUALIFIERS float4 clipPos : SV_POSITION;
				float4 clipPosV : TEXCOORD0;
				float3 worldNormal : TEXCOORD1;
				float4 worldTangent : TEXCOORD2;
				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 worldPos : TEXCOORD3;
				#endif
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					float4 shadowCoord : TEXCOORD4;
				#endif
				float4 ase_texcoord5 : TEXCOORD5;
				float4 ase_texcoord6 : TEXCOORD6;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			float4 _EmissionTint;
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			sampler2D _NormalMap;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			sampler2D _MetalMask;
			sampler2D _ShineMask;
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/DepthNormalsOnlyPass.hlsl"

			//#ifdef HAVE_VFX_MODIFICATION
			//#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/VisualEffectVertex.hlsl"
			//#endif

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11822( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11815( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11813( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11814( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11809( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11837( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11841( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11839( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11848( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11856( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11858( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11854( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11850( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11852( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			

			VertexOutput VertexFunction( VertexInput v  )
			{
				VertexOutput o = (VertexOutput)0;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);

				float2 _ZeroVector = float2(0,0);
				float2 texCoord363 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_clipPos = TransformObjectToHClip((v.vertex).xyz);
				float4 screenPos = ComputeScreenPos(ase_clipPos);
				float4 ase_screenPosNorm = screenPos / screenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				float3 ase_worldPos = TransformObjectToWorld( (v.vertex).xyz );
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (ase_worldPos).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				#ifdef _ENABLESQUISH_ON
				float2 break77_g11874 = fixedUV475;
				float2 appendResult72_g11874 = (float2(( _SquishStretch * ( break77_g11874.x - 0.5 ) * _SquishFade ) , ( _SquishFade * ( break77_g11874.y + _SquishFlip ) * -_SquishSquish )));
				float2 staticSwitch198 = ( appendResult72_g11874 + _ZeroVector );
				#else
				float2 staticSwitch198 = _ZeroVector;
				#endif
				float2 temp_output_2_0_g11876 = staticSwitch198;
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				float temp_output_8_0_g11876 = shaderTime237;
				#ifdef _ENABLESINEMOVE_ON
				float2 staticSwitch4_g11876 = ( ( sin( ( temp_output_8_0_g11876 * _SineMoveFrequency ) ) * _SineMoveOffset * _SineMoveFade ) + temp_output_2_0_g11876 );
				#else
				float2 staticSwitch4_g11876 = temp_output_2_0_g11876;
				#endif
				#ifdef _ENABLEVIBRATE_ON
				float temp_output_30_0_g11877 = temp_output_8_0_g11876;
				float3 rotatedValue21_g11877 = RotateAroundAxis( float3( 0,0,0 ), float3( 0,1,0 ), float3( 0,0,1 ), ( temp_output_30_0_g11877 * _VibrateRotation ) );
				float2 staticSwitch6_g11876 = ( ( sin( ( _VibrateFrequency * temp_output_30_0_g11877 ) ) * _VibrateOffset * _VibrateFade * (rotatedValue21_g11877).xy ) + staticSwitch4_g11876 );
				#else
				float2 staticSwitch6_g11876 = staticSwitch4_g11876;
				#endif
				#ifdef _ENABLESINESCALE_ON
				float2 staticSwitch10_g11876 = ( staticSwitch6_g11876 + ( (v.vertex.xyz).xy * ( ( ( sin( ( _SineScaleFrequency * temp_output_8_0_g11876 ) ) + 1.0 ) * 0.5 ) * _SineScaleFactor ) ) );
				#else
				float2 staticSwitch10_g11876 = staticSwitch6_g11876;
				#endif
				float2 temp_output_424_0 = staticSwitch10_g11876;
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = v.ase_texcoord.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2Dlod( _FadingMask, float4( uv_FadingMask, 0, 0.0) );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float2 texCoord435 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = v.ase_texcoord.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (v.vertex.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (v.vertex.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (ase_worldPos).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				float linValue16_g11712 = tex2Dlod( _UberNoiseTexture, float4( ( shaderPosition235 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2Dlod( _UberNoiseTexture, float4( ( temp_output_27_0_g11714 * _FadingNoiseScale ), 0, 0.0) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult121 = lerp( float2( 0,0 ) , temp_output_424_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch142 = temp_output_424_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch142 = lerpResult121;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch142 = lerpResult121;
				#else
				float2 staticSwitch142 = temp_output_424_0;
				#endif
				
				o.ase_texcoord5.xy = v.ase_texcoord.xy;
				o.ase_texcoord6 = v.vertex;
				o.ase_color = v.ase_color;
				
				//setting value to unused interpolator channels and avoid initialization warnings
				o.ase_texcoord5.zw = 0;
				#ifdef ASE_ABSOLUTE_VERTEX_POS
					float3 defaultVertexValue = v.vertex.xyz;
				#else
					float3 defaultVertexValue = float3(0, 0, 0);
				#endif

				float3 vertexValue = float3( staticSwitch142 ,  0.0 );

				#ifdef ASE_ABSOLUTE_VERTEX_POS
					v.vertex.xyz = vertexValue;
				#else
					v.vertex.xyz += vertexValue;
				#endif

				v.ase_normal = v.ase_normal;
				float3 positionWS = TransformObjectToWorld( v.vertex.xyz );
				float3 normalWS = TransformObjectToWorldNormal( v.ase_normal );
				float4 tangentWS = float4(TransformObjectToWorldDir( v.ase_tangent.xyz), v.ase_tangent.w);
				float4 positionCS = TransformWorldToHClip( positionWS );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					o.worldPos = positionWS;
				#endif

				o.worldNormal = normalWS;
				o.worldTangent = tangentWS;

				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR) && defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					VertexPositionInputs vertexInput = (VertexPositionInputs)0;
					vertexInput.positionWS = positionWS;
					vertexInput.positionCS = positionCS;
					o.shadowCoord = GetShadowCoord( vertexInput );
				#endif

				o.clipPos = positionCS;
				o.clipPosV = positionCS;
				return o;
			}

			#if defined(ASE_TESSELLATION)
			struct VertexControl
			{
				float4 vertex : INTERNALTESSPOS;
				float3 ase_normal : NORMAL;
				float4 ase_tangent : TANGENT;
				float4 ase_texcoord : TEXCOORD0;
				float4 ase_color : COLOR;

				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct TessellationFactors
			{
				float edge[3] : SV_TessFactor;
				float inside : SV_InsideTessFactor;
			};

			VertexControl vert ( VertexInput v )
			{
				VertexControl o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_TRANSFER_INSTANCE_ID(v, o);
				o.vertex = v.vertex;
				o.ase_normal = v.ase_normal;
				o.ase_tangent = v.ase_tangent;
				o.ase_texcoord = v.ase_texcoord;
				o.ase_color = v.ase_color;
				return o;
			}

			TessellationFactors TessellationFunction (InputPatch<VertexControl,3> v)
			{
				TessellationFactors o;
				float4 tf = 1;
				float tessValue = _TessValue; float tessMin = _TessMin; float tessMax = _TessMax;
				float edgeLength = _TessEdgeLength; float tessMaxDisp = _TessMaxDisp;
				#if defined(ASE_FIXED_TESSELLATION)
				tf = FixedTess( tessValue );
				#elif defined(ASE_DISTANCE_TESSELLATION)
				tf = DistanceBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, tessValue, tessMin, tessMax, GetObjectToWorldMatrix(), _WorldSpaceCameraPos );
				#elif defined(ASE_LENGTH_TESSELLATION)
				tf = EdgeLengthBasedTess(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams );
				#elif defined(ASE_LENGTH_CULL_TESSELLATION)
				tf = EdgeLengthBasedTessCull(v[0].vertex, v[1].vertex, v[2].vertex, edgeLength, tessMaxDisp, GetObjectToWorldMatrix(), _WorldSpaceCameraPos, _ScreenParams, unity_CameraWorldClipPlanes );
				#endif
				o.edge[0] = tf.x; o.edge[1] = tf.y; o.edge[2] = tf.z; o.inside = tf.w;
				return o;
			}

			[domain("tri")]
			[partitioning("fractional_odd")]
			[outputtopology("triangle_cw")]
			[patchconstantfunc("TessellationFunction")]
			[outputcontrolpoints(3)]
			VertexControl HullFunction(InputPatch<VertexControl, 3> patch, uint id : SV_OutputControlPointID)
			{
				return patch[id];
			}

			[domain("tri")]
			VertexOutput DomainFunction(TessellationFactors factors, OutputPatch<VertexControl, 3> patch, float3 bary : SV_DomainLocation)
			{
				VertexInput o = (VertexInput) 0;
				o.vertex = patch[0].vertex * bary.x + patch[1].vertex * bary.y + patch[2].vertex * bary.z;
				o.ase_normal = patch[0].ase_normal * bary.x + patch[1].ase_normal * bary.y + patch[2].ase_normal * bary.z;
				o.ase_tangent = patch[0].ase_tangent * bary.x + patch[1].ase_tangent * bary.y + patch[2].ase_tangent * bary.z;
				o.ase_texcoord = patch[0].ase_texcoord * bary.x + patch[1].ase_texcoord * bary.y + patch[2].ase_texcoord * bary.z;
				o.ase_color = patch[0].ase_color * bary.x + patch[1].ase_color * bary.y + patch[2].ase_color * bary.z;
				#if defined(ASE_PHONG_TESSELLATION)
				float3 pp[3];
				for (int i = 0; i < 3; ++i)
					pp[i] = o.vertex.xyz - patch[i].ase_normal * (dot(o.vertex.xyz, patch[i].ase_normal) - dot(patch[i].vertex.xyz, patch[i].ase_normal));
				float phongStrength = _TessPhongStrength;
				o.vertex.xyz = phongStrength * (pp[0]*bary.x + pp[1]*bary.y + pp[2]*bary.z) + (1.0f-phongStrength) * o.vertex.xyz;
				#endif
				UNITY_TRANSFER_INSTANCE_ID(patch[0], o);
				return VertexFunction(o);
			}
			#else
			VertexOutput vert ( VertexInput v )
			{
				return VertexFunction( v );
			}
			#endif

			half4 frag(	VertexOutput IN
						#ifdef ASE_DEPTH_WRITE_ON
						,out float outputDepth : ASE_SV_DEPTH
						#endif
						 ) : SV_TARGET
			{
				UNITY_SETUP_INSTANCE_ID(IN);
				UNITY_SETUP_STEREO_EYE_INDEX_POST_VERTEX( IN );

				#if defined(ASE_NEEDS_FRAG_WORLD_POSITION)
					float3 WorldPosition = IN.worldPos;
				#endif

				float4 ShadowCoords = float4( 0, 0, 0, 0 );
				float3 WorldNormal = IN.worldNormal;
				float4 WorldTangent = IN.worldTangent;

				float4 ClipPos = IN.clipPosV;
				float4 ScreenPos = ComputeScreenPos( IN.clipPosV );

				#if defined(ASE_NEEDS_FRAG_SHADOWCOORDS)
					#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
						ShadowCoords = IN.shadowCoord;
					#elif defined(MAIN_LIGHT_CALCULATE_SHADOWS)
						ShadowCoords = TransformWorldToShadowCoord( WorldPosition );
					#endif
				#endif

				float2 texCoord363 = IN.ase_texcoord5.xy * float2( 1,1 ) + float2( 0,0 );
				float4 ase_screenPosNorm = ScreenPos / ScreenPos.w;
				#ifdef _ENABLESCREENTILING_ON
				ase_screenPosNorm.z = ( UNITY_NEAR_CLIP_VALUE >= 0 ) ? ase_screenPosNorm.z : ase_screenPosNorm.z * 0.5 + 0.5;
				float2 appendResult16_g11656 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11656 = ( ( ( (( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / 10.0 ) )).xy * _ScreenTilingScale ) + _ScreenTilingOffset ) * ( _ScreenTilingPixelsPerUnit * appendResult16_g11656 ) );
				#else
				float2 staticSwitch2_g11656 = texCoord363;
				#endif
				#ifdef _ENABLEWORLDTILING_ON
				float2 appendResult16_g11657 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 staticSwitch2_g11657 = ( ( ( (WorldPosition).xy * _WorldTilingScale ) + _WorldTilingOffset ) * ( _WorldTilingPixelsPerUnit * appendResult16_g11657 ) );
				#else
				float2 staticSwitch2_g11657 = staticSwitch2_g11656;
				#endif
				float2 originalUV460 = staticSwitch2_g11657;
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11658 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch449 = ( floor( ( originalUV460 * appendResult7_g11658 ) ) / appendResult7_g11658 );
				#else
				float2 staticSwitch449 = originalUV460;
				#endif
				float2 uvAfterPixelArt450 = staticSwitch449;
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11664 = uvAfterPixelArt450;
				float2 appendResult374 = (float2(_SpriteSheetRect.x , _SpriteSheetRect.y));
				float2 spriteRectMin376 = appendResult374;
				float2 break11_g11664 = spriteRectMin376;
				float2 appendResult375 = (float2(_SpriteSheetRect.z , _SpriteSheetRect.w));
				float2 spriteRectMax377 = appendResult375;
				float2 break10_g11664 = spriteRectMax377;
				float2 break9_g11664 = float2( 0,0 );
				float2 break8_g11664 = float2( 1,1 );
				float2 appendResult15_g11664 = (float2((break9_g11664.x + (break14_g11664.x - break11_g11664.x) * (break8_g11664.x - break9_g11664.x) / (break10_g11664.x - break11_g11664.x)) , (break9_g11664.y + (break14_g11664.y - break11_g11664.y) * (break8_g11664.y - break9_g11664.y) / (break10_g11664.y - break11_g11664.y))));
				float2 staticSwitch366 = appendResult15_g11664;
				#else
				float2 staticSwitch366 = uvAfterPixelArt450;
				#endif
				float2 fixedUV475 = staticSwitch366;
				float2 temp_output_3_0_g11666 = fixedUV475;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch117_g11667 = _WindMinIntensity;
				#else
				float staticSwitch117_g11667 = WindMinIntensity;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch118_g11667 = _WindMaxIntensity;
				#else
				float staticSwitch118_g11667 = WindMaxIntensity;
				#endif
				#endif
				float4 transform62_g11667 = mul(GetWorldToObjectMatrix(),float4( 0,0,0,1 ));
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDISPARALLAX_ON
				float staticSwitch111_g11667 = _WindXPosition;
				#else
				float staticSwitch111_g11667 = transform62_g11667.x;
				#endif
				#endif
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch113_g11667 = _WindNoiseScale;
				#else
				float staticSwitch113_g11667 = WindNoiseScale;
				#endif
				#endif
				#ifdef _TOGGLECUSTOMTIME_ON
				float staticSwitch44_g11663 = _TimeValue;
				#else
				float staticSwitch44_g11663 = _TimeParameters.x;
				#endif
				#ifdef _TOGGLEUNSCALEDTIME_ON
				float staticSwitch34_g11663 = UnscaledTime;
				#else
				float staticSwitch34_g11663 = staticSwitch44_g11663;
				#endif
				#ifdef _TOGGLETIMESPEED_ON
				float staticSwitch37_g11663 = ( staticSwitch34_g11663 * _TimeSpeed );
				#else
				float staticSwitch37_g11663 = staticSwitch34_g11663;
				#endif
				#ifdef _TOGGLETIMEFPS_ON
				float staticSwitch38_g11663 = ( floor( ( staticSwitch37_g11663 * _TimeFPS ) ) / _TimeFPS );
				#else
				float staticSwitch38_g11663 = staticSwitch37_g11663;
				#endif
				#ifdef _TOGGLETIMEFREQUENCY_ON
				float staticSwitch42_g11663 = ( ( sin( ( staticSwitch38_g11663 * _TimeFrequency ) ) * _TimeRange ) + 100.0 );
				#else
				float staticSwitch42_g11663 = staticSwitch38_g11663;
				#endif
				float shaderTime237 = staticSwitch42_g11663;
				#ifdef _ENABLEWIND_ON
				#ifdef _WINDLOCALWIND_ON
				float staticSwitch125_g11667 = ( shaderTime237 * _WindNoiseSpeed );
				#else
				float staticSwitch125_g11667 = WindTime;
				#endif
				float temp_output_50_0_g11667 = ( ( staticSwitch111_g11667 * staticSwitch113_g11667 ) + staticSwitch125_g11667 );
				float x101_g11667 = temp_output_50_0_g11667;
				float localFastNoise101_g11667 = FastNoise101_g11667( x101_g11667 );
				float2 temp_cast_0 = (temp_output_50_0_g11667).xx;
				float simplePerlin2D121_g11667 = snoise( temp_cast_0*0.5 );
				simplePerlin2D121_g11667 = simplePerlin2D121_g11667*0.5 + 0.5;
				#ifdef _WINDHIGHQUALITYNOISE_ON
				float staticSwitch123_g11667 = simplePerlin2D121_g11667;
				#else
				float staticSwitch123_g11667 = ( localFastNoise101_g11667 + 0.5 );
				#endif
				float lerpResult86_g11667 = lerp( staticSwitch117_g11667 , staticSwitch118_g11667 , staticSwitch123_g11667);
				float clampResult29_g11667 = clamp( ( ( _WindRotationWindFactor * lerpResult86_g11667 ) + _WindRotation ) , -_WindMaxRotation , _WindMaxRotation );
				float2 temp_output_1_0_g11667 = temp_output_3_0_g11666;
				float temp_output_39_0_g11667 = ( temp_output_1_0_g11667.y + _WindFlip );
				float3 appendResult43_g11667 = (float3(0.5 , -_WindFlip , 0.0));
				float2 appendResult27_g11667 = (float2(0.0 , ( _WindSquishFactor * min( ( ( _WindSquishWindFactor * abs( lerpResult86_g11667 ) ) + abs( _WindRotation ) ) , _WindMaxRotation ) * temp_output_39_0_g11667 )));
				float3 rotatedValue19_g11667 = RotateAroundAxis( appendResult43_g11667, float3( ( appendResult27_g11667 + temp_output_1_0_g11667 ) ,  0.0 ), float3( 0,0,1 ), ( clampResult29_g11667 * temp_output_39_0_g11667 ) );
				float2 staticSwitch4_g11666 = (rotatedValue19_g11667).xy;
				#else
				float2 staticSwitch4_g11666 = temp_output_3_0_g11666;
				#endif
				float2 texCoord435 = IN.ase_texcoord5.xy * float2( 1,1 ) + float2( 0,0 );
				#ifdef _PIXELPERFECTSPACE_ON
				float2 temp_output_432_0 = (_MainTex_TexelSize).zw;
				float2 staticSwitch437 = ( floor( ( texCoord435 * temp_output_432_0 ) ) / temp_output_432_0 );
				#else
				float2 staticSwitch437 = texCoord435;
				#endif
				float2 temp_output_61_0_g11665 = staticSwitch437;
				float3 ase_objectScale = float3( length( GetObjectToWorldMatrix()[ 0 ].xyz ), length( GetObjectToWorldMatrix()[ 1 ].xyz ), length( GetObjectToWorldMatrix()[ 2 ].xyz ) );
				float2 texCoord23_g11665 = IN.ase_texcoord5.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERSPACE_UI_GRAPHIC
				float2 appendResult28_g11665 = (float2(_RectWidth , _RectHeight));
				#endif
				#if defined(_SHADERSPACE_UV)
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#elif defined(_SHADERSPACE_UV_RAW)
				float2 staticSwitch1_g11665 = temp_output_61_0_g11665;
				#elif defined(_SHADERSPACE_OBJECT)
				float2 staticSwitch1_g11665 = (IN.ase_texcoord6.xyz).xy;
				#elif defined(_SHADERSPACE_OBJECT_SCALED)
				float2 staticSwitch1_g11665 = ( (IN.ase_texcoord6.xyz).xy * (ase_objectScale).xy );
				#elif defined(_SHADERSPACE_WORLD)
				float2 staticSwitch1_g11665 = (WorldPosition).xy;
				#elif defined(_SHADERSPACE_UI_GRAPHIC)
				float2 staticSwitch1_g11665 = ( texCoord23_g11665 * ( appendResult28_g11665 / _PixelsPerUnit ) );
				#elif defined(_SHADERSPACE_SCREEN)
				float2 staticSwitch1_g11665 = ( ( (ase_screenPosNorm).xy * (_ScreenParams).xy ) / ( _ScreenParams.x / _ScreenWidthUnits ) );
				#else
				float2 staticSwitch1_g11665 = ( temp_output_61_0_g11665 / ( _PixelsPerUnit * (_MainTex_TexelSize).xy ) );
				#endif
				float2 shaderPosition235 = staticSwitch1_g11665;
				#ifdef _ENABLEFULLDISTORTION_ON
				float2 temp_output_195_0_g11668 = shaderPosition235;
				float linValue16_g11669 = tex2D( _UberNoiseTexture, ( temp_output_195_0_g11668 * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11669 = MyCustomExpression16_g11669( linValue16_g11669 );
				float linValue16_g11670 = tex2D( _UberNoiseTexture, ( ( temp_output_195_0_g11668 + float2( 0.321,0.321 ) ) * _FullDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11670 = MyCustomExpression16_g11670( linValue16_g11670 );
				float2 appendResult189_g11668 = (float2(( localMyCustomExpression16_g11669 - 0.5 ) , ( localMyCustomExpression16_g11670 - 0.5 )));
				float2 staticSwitch83 = ( staticSwitch4_g11666 + ( ( 1.0 - _FullDistortionFade ) * appendResult189_g11668 * _FullDistortionDistortion ) );
				#else
				float2 staticSwitch83 = staticSwitch4_g11666;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float2 temp_output_182_0_g11671 = shaderPosition235;
				float linValue16_g11673 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionDistortionScale ) ).r;
				float localMyCustomExpression16_g11673 = MyCustomExpression16_g11673( linValue16_g11673 );
				float3 rotatedValue168_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( _DirectionalDistortionDistortion ,  0.0 ), float3( 0,0,1 ), ( ( ( localMyCustomExpression16_g11673 - 0.5 ) * 2.0 * _DirectionalDistortionRandomDirection ) * PI ) );
				float3 rotatedValue136_g11671 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_182_0_g11671 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalDistortionRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11671 = rotatedValue136_g11671;
				float linValue16_g11672 = tex2D( _UberNoiseTexture, ( temp_output_182_0_g11671 * _DirectionalDistortionNoiseScale ) ).r;
				float localMyCustomExpression16_g11672 = MyCustomExpression16_g11672( linValue16_g11672 );
				float clampResult154_g11671 = clamp( ( ( break130_g11671.x + break130_g11671.y + _DirectionalDistortionFade + ( localMyCustomExpression16_g11672 * _DirectionalDistortionNoiseFactor ) ) / max( _DirectionalDistortionWidth , 0.001 ) ) , 0.0 , 1.0 );
				float2 staticSwitch82 = ( staticSwitch83 + ( (rotatedValue168_g11671).xy * ( 1.0 - (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 )) ) ) );
				#else
				float2 staticSwitch82 = staticSwitch83;
				#endif
				#ifdef _ENABLEHOLOGRAM_ON
				float temp_output_8_0_g11676 = ( ( ( shaderTime237 * _HologramDistortionSpeed ) + WorldPosition.y ) / unity_OrthoParams.y );
				float2 temp_cast_4 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_5 = (_HologramDistortionDensity).xx;
				float linValue16_g11678 = tex2D( _UberNoiseTexture, ( temp_cast_4 * temp_cast_5 ) ).r;
				float localMyCustomExpression16_g11678 = MyCustomExpression16_g11678( linValue16_g11678 );
				float clampResult75_g11676 = clamp( localMyCustomExpression16_g11678 , 0.075 , 0.6 );
				float2 temp_cast_6 = (temp_output_8_0_g11676).xx;
				float2 temp_cast_7 = (_HologramDistortionScale).xx;
				float linValue16_g11679 = tex2D( _UberNoiseTexture, ( temp_cast_6 * temp_cast_7 ) ).r;
				float localMyCustomExpression16_g11679 = MyCustomExpression16_g11679( linValue16_g11679 );
				float2 appendResult2_g11677 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float hologramFade182 = _HologramFade;
				float2 appendResult44_g11676 = (float2(( ( ( clampResult75_g11676 * ( localMyCustomExpression16_g11679 - 0.5 ) ) * _HologramDistortionOffset * ( 100.0 / appendResult2_g11677 ).x ) * hologramFade182 ) , 0.0));
				float2 staticSwitch59 = ( staticSwitch82 + appendResult44_g11676 );
				#else
				float2 staticSwitch59 = staticSwitch82;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float2 temp_output_18_0_g11674 = shaderPosition235;
				float2 glitchPosition154 = temp_output_18_0_g11674;
				float linValue16_g11717 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchDistortionSpeed * shaderTime237 ) ) * _GlitchDistortionScale ) ).r;
				float localMyCustomExpression16_g11717 = MyCustomExpression16_g11717( linValue16_g11717 );
				float linValue16_g11675 = tex2D( _UberNoiseTexture, ( ( temp_output_18_0_g11674 + ( _GlitchMaskSpeed * shaderTime237 ) ) * _GlitchMaskScale ) ).r;
				float localMyCustomExpression16_g11675 = MyCustomExpression16_g11675( linValue16_g11675 );
				float glitchFade152 = ( max( localMyCustomExpression16_g11675 , _GlitchMaskMin ) * _GlitchFade );
				float2 staticSwitch62 = ( staticSwitch59 + ( ( localMyCustomExpression16_g11717 - 0.5 ) * _GlitchDistortion * glitchFade152 ) );
				#else
				float2 staticSwitch62 = staticSwitch59;
				#endif
				float2 temp_output_1_0_g11718 = staticSwitch62;
				float2 temp_output_26_0_g11718 = shaderPosition235;
				float temp_output_25_0_g11718 = shaderTime237;
				#ifdef _ENABLEUVDISTORT_ON
				float linValue16_g11728 = tex2D( _UberNoiseTexture, ( ( temp_output_26_0_g11718 + ( _UVDistortSpeed * temp_output_25_0_g11718 ) ) * _UVDistortNoiseScale ) ).r;
				float localMyCustomExpression16_g11728 = MyCustomExpression16_g11728( linValue16_g11728 );
				float2 lerpResult21_g11725 = lerp( _UVDistortFrom , _UVDistortTo , localMyCustomExpression16_g11728);
				float2 appendResult2_g11727 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 uv_UVDistortMask = IN.ase_texcoord5.xy * _UVDistortMask_ST.xy + _UVDistortMask_ST.zw;
				float4 tex2DNode3_g11726 = tex2D( _UVDistortMask, uv_UVDistortMask );
				#ifdef _UVDISTORTMASKTOGGLE_ON
				float staticSwitch29_g11725 = ( _UVDistortFade * ( tex2DNode3_g11726.r * tex2DNode3_g11726.a ) );
				#else
				float staticSwitch29_g11725 = _UVDistortFade;
				#endif
				float2 staticSwitch5_g11718 = ( temp_output_1_0_g11718 + ( lerpResult21_g11725 * ( 100.0 / appendResult2_g11727 ) * staticSwitch29_g11725 ) );
				#else
				float2 staticSwitch5_g11718 = temp_output_1_0_g11718;
				#endif
				#ifdef _ENABLESQUEEZE_ON
				float2 temp_output_1_0_g11724 = staticSwitch5_g11718;
				float2 staticSwitch7_g11718 = ( temp_output_1_0_g11724 + ( ( temp_output_1_0_g11724 - _SqueezeCenter ) * pow( distance( temp_output_1_0_g11724 , _SqueezeCenter ) , _SqueezePower ) * _SqueezeScale * _SqueezeFade ) );
				#else
				float2 staticSwitch7_g11718 = staticSwitch5_g11718;
				#endif
				#ifdef _ENABLESINEROTATE_ON
				float3 rotatedValue36_g11723 = RotateAroundAxis( float3( _SineRotatePivot ,  0.0 ), float3( staticSwitch7_g11718 ,  0.0 ), float3( 0,0,1 ), ( sin( ( temp_output_25_0_g11718 * _SineRotateFrequency ) ) * ( ( _SineRotateAngle / 360.0 ) * PI ) * _SineRotateFade ) );
				float2 staticSwitch9_g11718 = (rotatedValue36_g11723).xy;
				#else
				float2 staticSwitch9_g11718 = staticSwitch7_g11718;
				#endif
				#ifdef _ENABLEUVROTATE_ON
				float3 rotatedValue8_g11722 = RotateAroundAxis( float3( _UVRotatePivot ,  0.0 ), float3( staticSwitch9_g11718 ,  0.0 ), float3( 0,0,1 ), ( temp_output_25_0_g11718 * _UVRotateSpeed * PI ) );
				float2 staticSwitch16_g11718 = (rotatedValue8_g11722).xy;
				#else
				float2 staticSwitch16_g11718 = staticSwitch9_g11718;
				#endif
				#ifdef _ENABLEUVSCROLL_ON
				float2 staticSwitch14_g11718 = ( ( _UVScrollSpeed * temp_output_25_0_g11718 ) + staticSwitch16_g11718 );
				#else
				float2 staticSwitch14_g11718 = staticSwitch16_g11718;
				#endif
				#ifdef _ENABLEPIXELATE_ON
				float2 appendResult35_g11720 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 MultFactor30_g11720 = ( ( _PixelatePixelDensity * ( appendResult35_g11720 / _PixelatePixelsPerUnit ) ) * ( 1.0 / max( _PixelateFade , 1E-05 ) ) );
				float2 clampResult46_g11720 = clamp( ( floor( ( MultFactor30_g11720 * ( staticSwitch14_g11718 + ( float2( 0.5,0.5 ) / MultFactor30_g11720 ) ) ) ) / MultFactor30_g11720 ) , float2( 0,0 ) , float2( 1,1 ) );
				float2 staticSwitch4_g11718 = clampResult46_g11720;
				#else
				float2 staticSwitch4_g11718 = staticSwitch14_g11718;
				#endif
				#ifdef _ENABLEUVSCALE_ON
				float2 staticSwitch24_g11718 = ( ( ( staticSwitch4_g11718 - _UVScalePivot ) / _UVScaleScale ) + _UVScalePivot );
				#else
				float2 staticSwitch24_g11718 = staticSwitch4_g11718;
				#endif
				float2 temp_output_1_0_g11729 = staticSwitch24_g11718;
				#ifdef _ENABLEWIGGLE_ON
				float temp_output_7_0_g11729 = ( sin( ( _WiggleFrequency * ( temp_output_26_0_g11718.y + ( _WiggleSpeed * temp_output_25_0_g11718 ) ) ) ) * _WiggleOffset * _WiggleFade );
				#ifdef _WIGGLEFIXEDGROUNDTOGGLE_ON
				float staticSwitch18_g11729 = ( temp_output_7_0_g11729 * temp_output_1_0_g11729.y );
				#else
				float staticSwitch18_g11729 = temp_output_7_0_g11729;
				#endif
				float2 appendResult12_g11729 = (float2(staticSwitch18_g11729 , 0.0));
				float2 staticSwitch13_g11729 = ( temp_output_1_0_g11729 + appendResult12_g11729 );
				#else
				float2 staticSwitch13_g11729 = temp_output_1_0_g11729;
				#endif
				float2 temp_output_484_0 = staticSwitch13_g11729;
				float2 texCoord131 = IN.ase_texcoord5.xy * float2( 1,1 ) + float2( 0,0 );
#ifdef _SHADERFADING_MASK
				float2 uv_FadingMask = IN.ase_texcoord5.xy * _FadingMask_ST.xy + _FadingMask_ST.zw;
				#endif
#ifdef _SHADERFADING_MASK
				float4 tex2DNode3_g11713 = tex2D( _FadingMask, uv_FadingMask );
				#endif
				float temp_output_4_0_g11711 = max( _FadingWidth , 0.001 );
				float linValue16_g11712 = tex2D( _UberNoiseTexture, ( shaderPosition235 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11712 = MyCustomExpression16_g11712( linValue16_g11712 );
				float clampResult14_g11711 = clamp( ( ( ( _FadingFade * ( 1.0 + temp_output_4_0_g11711 ) ) - localMyCustomExpression16_g11712 ) / temp_output_4_0_g11711 ) , 0.0 , 1.0 );
				float2 temp_output_27_0_g11714 = shaderPosition235;
				float linValue16_g11715 = tex2D( _UberNoiseTexture, ( temp_output_27_0_g11714 * _FadingNoiseScale ) ).r;
				float localMyCustomExpression16_g11715 = MyCustomExpression16_g11715( linValue16_g11715 );
#ifdef _SHADERFADING_SPREAD
				float clampResult3_g11714 = clamp( ( ( _FadingFade - ( distance( _FadingPosition , temp_output_27_0_g11714 ) + ( localMyCustomExpression16_g11715 * _FadingNoiseFactor ) ) ) / max( _FadingWidth , 0.001 ) ) , 0.0 , 1.0 );
				#endif
				#if defined(_SHADERFADING_NONE)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_FULL)
				float staticSwitch139 = _FadingFade;
				#elif defined(_SHADERFADING_MASK)
				float staticSwitch139 = ( _FadingFade * ( tex2DNode3_g11713.r * tex2DNode3_g11713.a ) );
				#elif defined(_SHADERFADING_DISSOLVE)
				float staticSwitch139 = clampResult14_g11711;
				#elif defined(_SHADERFADING_SPREAD)
				float staticSwitch139 = clampResult3_g11714;
				#else
				float staticSwitch139 = _FadingFade;
				#endif
				float fullFade123 = staticSwitch139;
				float2 lerpResult130 = lerp( texCoord131 , temp_output_484_0 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float2 staticSwitch145 = temp_output_484_0;
				#elif defined(_SHADERFADING_FULL)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_MASK)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_DISSOLVE)
				float2 staticSwitch145 = lerpResult130;
				#elif defined(_SHADERFADING_SPREAD)
				float2 staticSwitch145 = lerpResult130;
				#else
				float2 staticSwitch145 = temp_output_484_0;
				#endif
				#ifdef _TILINGFIX_ON
				float2 staticSwitch485 = ( ( ( staticSwitch145 % float2( 1,1 ) ) + float2( 1,1 ) ) % float2( 1,1 ) );
				#else
				float2 staticSwitch485 = staticSwitch145;
				#endif
				#ifdef _SPRITESHEETFIX_ON
				float2 break14_g11730 = staticSwitch485;
				float2 break11_g11730 = float2( 0,0 );
				float2 break10_g11730 = float2( 1,1 );
				float2 break9_g11730 = spriteRectMin376;
				float2 break8_g11730 = spriteRectMax377;
				float2 appendResult15_g11730 = (float2((break9_g11730.x + (break14_g11730.x - break11_g11730.x) * (break8_g11730.x - break9_g11730.x) / (break10_g11730.x - break11_g11730.x)) , (break9_g11730.y + (break14_g11730.y - break11_g11730.y) * (break8_g11730.y - break9_g11730.y) / (break10_g11730.y - break11_g11730.y))));
				float2 staticSwitch371 = min( max( appendResult15_g11730 , spriteRectMin376 ) , spriteRectMax377 );
				#else
				float2 staticSwitch371 = staticSwitch485;
				#endif
				#ifdef _PIXELPERFECTUV_ON
				float2 appendResult7_g11731 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 staticSwitch427 = ( originalUV460 + ( floor( ( ( staticSwitch371 - uvAfterPixelArt450 ) * appendResult7_g11731 ) ) / appendResult7_g11731 ) );
				#else
				float2 staticSwitch427 = staticSwitch371;
				#endif
				float2 finalUV146 = staticSwitch427;
				float2 temp_output_11_0_g11881 = finalUV146;
				float3 unpack3_g11881 = UnpackNormalScale( tex2D( _NormalMap, temp_output_11_0_g11881 ), _NormalIntensity );
				unpack3_g11881.z = lerp( 1, unpack3_g11881.z, saturate(_NormalIntensity) );
				
				float2 temp_output_1_0_g11732 = finalUV146;
				#ifdef _ENABLESMOOTHPIXELART_ON
				sampler2D tex3_g11733 = _MainTex;
				float4 textureTexelSize3_g11733 = _MainTex_TexelSize;
				float2 uvs3_g11733 = temp_output_1_0_g11732;
				float4 localtexturePointSmooth3_g11733 = texturePointSmooth( tex3_g11733 , textureTexelSize3_g11733 , uvs3_g11733 );
				float4 staticSwitch8_g11732 = localtexturePointSmooth3_g11733;
				#else
				float4 staticSwitch8_g11732 = tex2D( _MainTex, temp_output_1_0_g11732 );
				#endif
				#ifdef _ENABLEGAUSSIANBLUR_ON
				float temp_output_10_0_g11734 = ( _GaussianBlurOffset * _GaussianBlurFade * 0.005 );
				float temp_output_2_0_g11744 = temp_output_10_0_g11734;
				float2 appendResult16_g11744 = (float2(temp_output_2_0_g11744 , 0.0));
				float2 appendResult25_g11746 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11746 = ( appendResult16_g11744 * appendResult25_g11746 );
				float2 temp_output_7_0_g11734 = temp_output_1_0_g11732;
				float2 temp_output_1_0_g11744 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,1 ) ) );
				float2 temp_output_1_0_g11746 = temp_output_1_0_g11744;
				float2 appendResult17_g11744 = (float2(0.0 , temp_output_2_0_g11744));
				float2 appendResult25_g11745 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11745 = ( appendResult17_g11744 * appendResult25_g11745 );
				float2 temp_output_1_0_g11745 = temp_output_1_0_g11744;
				float temp_output_2_0_g11735 = temp_output_10_0_g11734;
				float2 appendResult16_g11735 = (float2(temp_output_2_0_g11735 , 0.0));
				float2 appendResult25_g11737 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11737 = ( appendResult16_g11735 * appendResult25_g11737 );
				float2 temp_output_1_0_g11735 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,1 ) ) );
				float2 temp_output_1_0_g11737 = temp_output_1_0_g11735;
				float2 appendResult17_g11735 = (float2(0.0 , temp_output_2_0_g11735));
				float2 appendResult25_g11736 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11736 = ( appendResult17_g11735 * appendResult25_g11736 );
				float2 temp_output_1_0_g11736 = temp_output_1_0_g11735;
				float temp_output_2_0_g11741 = temp_output_10_0_g11734;
				float2 appendResult16_g11741 = (float2(temp_output_2_0_g11741 , 0.0));
				float2 appendResult25_g11743 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11743 = ( appendResult16_g11741 * appendResult25_g11743 );
				float2 temp_output_1_0_g11741 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( -1,-1 ) ) );
				float2 temp_output_1_0_g11743 = temp_output_1_0_g11741;
				float2 appendResult17_g11741 = (float2(0.0 , temp_output_2_0_g11741));
				float2 appendResult25_g11742 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11742 = ( appendResult17_g11741 * appendResult25_g11742 );
				float2 temp_output_1_0_g11742 = temp_output_1_0_g11741;
				float temp_output_2_0_g11738 = temp_output_10_0_g11734;
				float2 appendResult16_g11738 = (float2(temp_output_2_0_g11738 , 0.0));
				float2 appendResult25_g11740 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11740 = ( appendResult16_g11738 * appendResult25_g11740 );
				float2 temp_output_1_0_g11738 = ( temp_output_7_0_g11734 + ( temp_output_10_0_g11734 * float2( 1,-1 ) ) );
				float2 temp_output_1_0_g11740 = temp_output_1_0_g11738;
				float2 appendResult17_g11738 = (float2(0.0 , temp_output_2_0_g11738));
				float2 appendResult25_g11739 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11739 = ( appendResult17_g11738 * appendResult25_g11739 );
				float2 temp_output_1_0_g11739 = temp_output_1_0_g11738;
				float4 staticSwitch3_g11732 = ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11746 + temp_output_1_0_g11746 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11745 + temp_output_1_0_g11745 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11737 + temp_output_1_0_g11737 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11736 + temp_output_1_0_g11736 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11743 + temp_output_1_0_g11743 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11742 + temp_output_1_0_g11742 ) ) ) ) + ( ( tex2D( _MainTex, ( temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11740 + temp_output_1_0_g11740 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11739 + temp_output_1_0_g11739 ) ) ) ) ) * 0.0625 );
				#else
				float4 staticSwitch3_g11732 = staticSwitch8_g11732;
				#endif
				#ifdef _ENABLESHARPEN_ON
				float2 temp_output_1_0_g11747 = temp_output_1_0_g11732;
				float4 tex2DNode4_g11747 = tex2D( _MainTex, temp_output_1_0_g11747 );
				float temp_output_2_0_g11748 = _SharpenOffset;
				float2 appendResult16_g11748 = (float2(temp_output_2_0_g11748 , 0.0));
				float2 appendResult25_g11750 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11750 = ( appendResult16_g11748 * appendResult25_g11750 );
				float2 temp_output_1_0_g11748 = temp_output_1_0_g11747;
				float2 temp_output_1_0_g11750 = temp_output_1_0_g11748;
				float2 appendResult17_g11748 = (float2(0.0 , temp_output_2_0_g11748));
				float2 appendResult25_g11749 = (float2(_MainTex_TexelSize.x , _MainTex_TexelSize.y));
				float2 temp_output_26_0_g11749 = ( appendResult17_g11748 * appendResult25_g11749 );
				float2 temp_output_1_0_g11749 = temp_output_1_0_g11748;
				float4 break22_g11747 = ( tex2DNode4_g11747 - ( ( ( ( ( tex2D( _MainTex, ( temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11750 + temp_output_1_0_g11750 ) ) ) + ( tex2D( _MainTex, ( temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) + tex2D( _MainTex, ( -temp_output_26_0_g11749 + temp_output_1_0_g11749 ) ) ) ) / 4.0 ) - tex2DNode4_g11747 ) * ( _SharpenFactor * _SharpenFade ) ) );
				float clampResult23_g11747 = clamp( break22_g11747.a , 0.0 , 1.0 );
				float4 appendResult24_g11747 = (float4(break22_g11747.r , break22_g11747.g , break22_g11747.b , clampResult23_g11747));
				float4 staticSwitch12_g11732 = appendResult24_g11747;
				#else
				float4 staticSwitch12_g11732 = staticSwitch3_g11732;
				#endif
				float4 temp_output_471_0 = staticSwitch12_g11732;
				#ifdef _VERTEXTINTFIRST_ON
				float4 temp_output_1_0_g11751 = temp_output_471_0;
				float4 appendResult8_g11751 = (float4(( (temp_output_1_0_g11751).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11751.a));
				float4 staticSwitch354 = appendResult8_g11751;
				#else
				float4 staticSwitch354 = temp_output_471_0;
				#endif
				float4 originalColor191 = staticSwitch354;
				float4 temp_output_1_0_g11752 = originalColor191;
				float4 temp_output_1_0_g11753 = temp_output_1_0_g11752;
				float2 temp_output_7_0_g11752 = finalUV146;
				#ifdef _ENABLESMOKE_ON
				float2 temp_output_43_0_g11753 = temp_output_7_0_g11752;
				float2 temp_cast_15 = (_SmokeNoiseScale).xx;
				float linValue16_g11754 = tex2D( _UberNoiseTexture, ( ( ( IN.ase_color.r * (( _SmokeVertexSeed )?( 5.0 ):( 0.0 )) ) + temp_output_43_0_g11753 ) * temp_cast_15 ) ).r;
				float localMyCustomExpression16_g11754 = MyCustomExpression16_g11754( linValue16_g11754 );
				float clampResult28_g11753 = clamp( ( ( ( localMyCustomExpression16_g11754 - 1.0 ) * _SmokeNoiseFactor ) + ( ( ( IN.ase_color.a / 2.5 ) - distance( temp_output_43_0_g11753 , float2( 0.5,0.5 ) ) ) * 2.5 * _SmokeSmoothness ) ) , 0.0 , 1.0 );
				float3 lerpResult34_g11753 = lerp( (temp_output_1_0_g11753).rgb , float3( 0,0,0 ) , ( ( 1.0 - clampResult28_g11753 ) * _SmokeDarkEdge ));
				float4 appendResult31_g11753 = (float4(lerpResult34_g11753 , ( clampResult28_g11753 * _SmokeAlpha * temp_output_1_0_g11753.a )));
				float4 staticSwitch2_g11752 = appendResult31_g11753;
				#else
				float4 staticSwitch2_g11752 = temp_output_1_0_g11752;
				#endif
				#ifdef _ENABLECUSTOMFADE_ON
				float4 temp_output_1_0_g11755 = staticSwitch2_g11752;
				float2 temp_output_57_0_g11755 = temp_output_7_0_g11752;
				float4 tex2DNode3_g11755 = tex2D( _CustomFadeFadeMask, temp_output_57_0_g11755 );
				float linValue16_g11756 = tex2D( _UberNoiseTexture, ( temp_output_57_0_g11755 * _CustomFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11756 = MyCustomExpression16_g11756( linValue16_g11756 );
				float clampResult37_g11755 = clamp( ( ( ( IN.ase_color.a * 2.0 ) - 1.0 ) + ( tex2DNode3_g11755.r + ( localMyCustomExpression16_g11756 * _CustomFadeNoiseFactor ) ) ) , 0.0 , 1.0 );
				float4 appendResult13_g11755 = (float4((temp_output_1_0_g11755).rgb , ( temp_output_1_0_g11755.a * pow( clampResult37_g11755 , ( _CustomFadeSmoothness / max( tex2DNode3_g11755.r , 0.05 ) ) ) * _CustomFadeAlpha )));
				float4 staticSwitch3_g11752 = appendResult13_g11755;
				#else
				float4 staticSwitch3_g11752 = staticSwitch2_g11752;
				#endif
				float4 temp_output_1_0_g11757 = staticSwitch3_g11752;
				#ifdef _ENABLECHECKERBOARD_ON
				float4 temp_output_1_0_g11758 = temp_output_1_0_g11757;
				float2 appendResult4_g11758 = (float2(WorldPosition.x , WorldPosition.y));
				float2 temp_output_44_0_g11758 = ( appendResult4_g11758 * _CheckerboardTiling * 0.5 );
				float2 break12_g11758 = step( ( ceil( temp_output_44_0_g11758 ) - temp_output_44_0_g11758 ) , float2( 0.5,0.5 ) );
				float4 appendResult42_g11758 = (float4(( (temp_output_1_0_g11758).rgb * min( ( _CheckerboardDarken + abs( ( -break12_g11758.x + break12_g11758.y ) ) ) , 1.0 ) ) , temp_output_1_0_g11758.a));
				float4 staticSwitch2_g11757 = appendResult42_g11758;
				#else
				float4 staticSwitch2_g11757 = temp_output_1_0_g11757;
				#endif
				#ifdef _ENABLEFLAME_ON
				float2 temp_output_75_0_g11759 = finalUV146;
				float linValue16_g11760 = tex2D( _UberNoiseTexture, ( ( ( shaderTime237 * _FlameSpeed ) + temp_output_75_0_g11759 ) * _FlameNoiseScale ) ).r;
				float localMyCustomExpression16_g11760 = MyCustomExpression16_g11760( linValue16_g11760 );
				float saferPower57_g11759 = abs( max( ( temp_output_75_0_g11759.y - 0.2 ) , 0.0 ) );
				float temp_output_47_0_g11759 = max( _FlameRadius , 0.01 );
				float clampResult70_g11759 = clamp( ( ( ( localMyCustomExpression16_g11760 * pow( saferPower57_g11759 , _FlameNoiseHeightFactor ) * _FlameNoiseFactor ) + ( ( temp_output_47_0_g11759 - distance( temp_output_75_0_g11759 , float2( 0.5,0.4 ) ) ) / temp_output_47_0_g11759 ) ) * _FlameSmooth ) , 0.0 , 1.0 );
				float temp_output_63_0_g11759 = ( clampResult70_g11759 * _FlameBrightness );
				float4 appendResult31_g11759 = (float4(temp_output_63_0_g11759 , temp_output_63_0_g11759 , temp_output_63_0_g11759 , clampResult70_g11759));
				float4 staticSwitch6_g11757 = ( appendResult31_g11759 * staticSwitch2_g11757 );
				#else
				float4 staticSwitch6_g11757 = staticSwitch2_g11757;
				#endif
				float4 temp_output_3_0_g11761 = staticSwitch6_g11757;
				float4 temp_output_1_0_g11788 = temp_output_3_0_g11761;
				float2 temp_output_1_0_g11761 = finalUV146;
				#ifdef _ENABLERECOLORRGB_ON
				#ifdef _RECOLORRGBTEXTURETOGGLE_ON
				float4 staticSwitch81_g11788 = tex2D( _RecolorRGBTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch81_g11788 = temp_output_1_0_g11788;
				#endif
				float4 break82_g11788 = staticSwitch81_g11788;
				float temp_output_63_0_g11788 = ( break82_g11788.r + break82_g11788.g + break82_g11788.b );
				float4 break71_g11788 = ( ( _RecolorRGBRedTint * ( break82_g11788.r / temp_output_63_0_g11788 ) ) + ( _RecolorRGBGreenTint * ( break82_g11788.g / temp_output_63_0_g11788 ) ) + ( ( break82_g11788.b / temp_output_63_0_g11788 ) * _RecolorRGBBlueTint ) );
				float3 appendResult56_g11788 = (float3(break71_g11788.r , break71_g11788.g , break71_g11788.b));
				float4 break2_g11789 = temp_output_1_0_g11788;
				float saferPower57_g11788 = abs( ( ( break2_g11789.x + break2_g11789.x + break2_g11789.y + break2_g11789.y + break2_g11789.y + break2_g11789.z ) / 6.0 ) );
				float3 lerpResult26_g11788 = lerp( (temp_output_1_0_g11788).rgb , ( appendResult56_g11788 * pow( saferPower57_g11788 , ( max( break71_g11788.a , 0.01 ) * 2.0 ) ) ) , ( min( ( temp_output_63_0_g11788 * 2.0 ) , 1.0 ) * _RecolorRGBFade ));
				float4 appendResult30_g11788 = (float4(lerpResult26_g11788 , temp_output_1_0_g11788.a));
				float4 staticSwitch43_g11761 = appendResult30_g11788;
				#else
				float4 staticSwitch43_g11761 = temp_output_3_0_g11761;
				#endif
				#ifdef _ENABLERECOLORRGBYCP_ON
				float4 temp_output_1_0_g11786 = staticSwitch43_g11761;
				#ifdef _RECOLORRGBYCPTEXTURETOGGLE_ON
				float4 staticSwitch62_g11786 = tex2D( _RecolorRGBYCPTexture, temp_output_1_0_g11761 );
				#else
				float4 staticSwitch62_g11786 = temp_output_1_0_g11786;
				#endif
				float3 hsvTorgb33_g11786 = RGBToHSV( staticSwitch62_g11786.rgb );
				float temp_output_43_0_g11786 = ( ( hsvTorgb33_g11786.x + 0.08333334 ) % 1.0 );
				float4 ifLocalVar46_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.8333333 )
				ifLocalVar46_g11786 = _RecolorRGBYCPPurpleTint;
				else
				ifLocalVar46_g11786 = _RecolorRGBYCPBlueTint;
				float4 ifLocalVar44_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.6666667 )
				ifLocalVar44_g11786 = _RecolorRGBYCPCyanTint;
				else
				ifLocalVar44_g11786 = ifLocalVar46_g11786;
				float4 ifLocalVar47_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.3333333 )
				ifLocalVar47_g11786 = _RecolorRGBYCPYellowTint;
				else
				ifLocalVar47_g11786 = _RecolorRGBYCPGreenTint;
				float4 ifLocalVar45_g11786 = 0;
				if( temp_output_43_0_g11786 <= 0.1666667 )
				ifLocalVar45_g11786 = _RecolorRGBYCPRedTint;
				else
				ifLocalVar45_g11786 = ifLocalVar47_g11786;
				float4 ifLocalVar35_g11786 = 0;
				if( temp_output_43_0_g11786 >= 0.5 )
				ifLocalVar35_g11786 = ifLocalVar44_g11786;
				else
				ifLocalVar35_g11786 = ifLocalVar45_g11786;
				float4 break55_g11786 = ifLocalVar35_g11786;
				float3 appendResult56_g11786 = (float3(break55_g11786.r , break55_g11786.g , break55_g11786.b));
				float4 break2_g11787 = temp_output_1_0_g11786;
				float saferPower57_g11786 = abs( ( ( break2_g11787.x + break2_g11787.x + break2_g11787.y + break2_g11787.y + break2_g11787.y + break2_g11787.z ) / 6.0 ) );
				float3 lerpResult26_g11786 = lerp( (temp_output_1_0_g11786).rgb , ( appendResult56_g11786 * pow( saferPower57_g11786 , max( ( break55_g11786.a * 2.0 ) , 0.01 ) ) ) , ( hsvTorgb33_g11786.z * _RecolorRGBYCPFade ));
				float4 appendResult30_g11786 = (float4(lerpResult26_g11786 , temp_output_1_0_g11786.a));
				float4 staticSwitch9_g11761 = appendResult30_g11786;
				#else
				float4 staticSwitch9_g11761 = staticSwitch43_g11761;
				#endif
				#ifdef _ENABLECOLORREPLACE_ON
				float4 temp_output_1_0_g11764 = staticSwitch9_g11761;
				float3 temp_output_2_0_g11764 = (temp_output_1_0_g11764).rgb;
				float3 In115_g11764 = temp_output_2_0_g11764;
				float3 From115_g11764 = (_ColorReplaceFromColor).rgb;
				float4 break2_g11765 = temp_output_1_0_g11764;
				float3 To115_g11764 = ( pow( ( ( break2_g11765.x + break2_g11765.x + break2_g11765.y + break2_g11765.y + break2_g11765.y + break2_g11765.z ) / 6.0 ) , max( _ColorReplaceContrast , 0.0001 ) ) * (_ColorReplaceToColor).rgb );
				float Fuzziness115_g11764 = _ColorReplaceSmoothness;
				float Range115_g11764 = _ColorReplaceRange;
				float3 localMyCustomExpression115_g11764 = MyCustomExpression115_g11764( In115_g11764 , From115_g11764 , To115_g11764 , Fuzziness115_g11764 , Range115_g11764 );
				float3 lerpResult112_g11764 = lerp( temp_output_2_0_g11764 , localMyCustomExpression115_g11764 , _ColorReplaceFade);
				float4 appendResult4_g11764 = (float4(lerpResult112_g11764 , temp_output_1_0_g11764.a));
				float4 staticSwitch29_g11761 = appendResult4_g11764;
				#else
				float4 staticSwitch29_g11761 = staticSwitch9_g11761;
				#endif
				float4 temp_output_1_0_g11775 = staticSwitch29_g11761;
				#ifdef _ENABLENEGATIVE_ON
				float3 temp_output_9_0_g11775 = (temp_output_1_0_g11775).rgb;
				float3 lerpResult3_g11775 = lerp( temp_output_9_0_g11775 , ( 1.0 - temp_output_9_0_g11775 ) , _NegativeFade);
				float4 appendResult8_g11775 = (float4(lerpResult3_g11775 , temp_output_1_0_g11775.a));
				float4 staticSwitch4_g11775 = appendResult8_g11775;
				#else
				float4 staticSwitch4_g11775 = temp_output_1_0_g11775;
				#endif
				float4 temp_output_57_0_g11761 = staticSwitch4_g11775;
				#ifdef _ENABLECONTRAST_ON
				float4 temp_output_1_0_g11796 = temp_output_57_0_g11761;
				float3 saferPower5_g11796 = abs( (temp_output_1_0_g11796).rgb );
				float3 temp_cast_29 = (_Contrast).xxx;
				float4 appendResult4_g11796 = (float4(pow( saferPower5_g11796 , temp_cast_29 ) , temp_output_1_0_g11796.a));
				float4 staticSwitch32_g11761 = appendResult4_g11796;
				#else
				float4 staticSwitch32_g11761 = temp_output_57_0_g11761;
				#endif
				#ifdef _ENABLEBRIGHTNESS_ON
				float4 temp_output_2_0_g11773 = staticSwitch32_g11761;
				float4 appendResult6_g11773 = (float4(( (temp_output_2_0_g11773).rgb * _Brightness ) , temp_output_2_0_g11773.a));
				float4 staticSwitch33_g11761 = appendResult6_g11773;
				#else
				float4 staticSwitch33_g11761 = staticSwitch32_g11761;
				#endif
				#ifdef _ENABLEHUE_ON
				float4 temp_output_2_0_g11774 = staticSwitch33_g11761;
				float3 hsvTorgb1_g11774 = RGBToHSV( temp_output_2_0_g11774.rgb );
				float3 hsvTorgb3_g11774 = HSVToRGB( float3(( hsvTorgb1_g11774.x + _Hue ),hsvTorgb1_g11774.y,hsvTorgb1_g11774.z) );
				float4 appendResult8_g11774 = (float4(hsvTorgb3_g11774 , temp_output_2_0_g11774.a));
				float4 staticSwitch36_g11761 = appendResult8_g11774;
				#else
				float4 staticSwitch36_g11761 = staticSwitch33_g11761;
				#endif
				#ifdef _ENABLESPLITTONING_ON
				float4 temp_output_1_0_g11790 = staticSwitch36_g11761;
				float4 break2_g11791 = temp_output_1_0_g11790;
				float temp_output_3_0_g11790 = ( ( break2_g11791.x + break2_g11791.x + break2_g11791.y + break2_g11791.y + break2_g11791.y + break2_g11791.z ) / 6.0 );
				float clampResult25_g11790 = clamp( ( ( ( ( temp_output_3_0_g11790 + _SplitToningShift ) - 0.5 ) * _SplitToningBalance ) + 0.5 ) , 0.0 , 1.0 );
				float3 lerpResult6_g11790 = lerp( (_SplitToningShadowsColor).rgb , (_SplitToningHighlightsColor).rgb , clampResult25_g11790);
				float temp_output_9_0_g11792 = max( _SplitToningContrast , 0.0 );
				float saferPower7_g11792 = abs( ( temp_output_3_0_g11790 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11792 ) , 0.0 ) ) ) );
				float3 lerpResult11_g11790 = lerp( (temp_output_1_0_g11790).rgb , ( lerpResult6_g11790 * pow( saferPower7_g11792 , temp_output_9_0_g11792 ) ) , _SplitToningFade);
				float4 appendResult18_g11790 = (float4(lerpResult11_g11790 , temp_output_1_0_g11790.a));
				float4 staticSwitch30_g11761 = appendResult18_g11790;
				#else
				float4 staticSwitch30_g11761 = staticSwitch36_g11761;
				#endif
				#ifdef _ENABLEBLACKTINT_ON
				float4 temp_output_1_0_g11771 = staticSwitch30_g11761;
				float3 temp_output_4_0_g11771 = (temp_output_1_0_g11771).rgb;
				float4 break12_g11771 = temp_output_1_0_g11771;
				float3 lerpResult7_g11771 = lerp( temp_output_4_0_g11771 , ( temp_output_4_0_g11771 + (_BlackTintColor).rgb ) , pow( ( 1.0 - min( max( max( break12_g11771.r , break12_g11771.g ) , break12_g11771.b ) , 1.0 ) ) , max( _BlackTintPower , 0.001 ) ));
				float3 lerpResult13_g11771 = lerp( temp_output_4_0_g11771 , lerpResult7_g11771 , _BlackTintFade);
				float4 appendResult11_g11771 = (float4(lerpResult13_g11771 , break12_g11771.a));
				float4 staticSwitch20_g11761 = appendResult11_g11771;
				#else
				float4 staticSwitch20_g11761 = staticSwitch30_g11761;
				#endif
				#ifdef _ENABLEINKSPREAD_ON
				float4 temp_output_1_0_g11782 = staticSwitch20_g11761;
				float4 break2_g11784 = temp_output_1_0_g11782;
				float temp_output_9_0_g11785 = max( _InkSpreadContrast , 0.0 );
				float saferPower7_g11785 = abs( ( ( ( break2_g11784.x + break2_g11784.x + break2_g11784.y + break2_g11784.y + break2_g11784.y + break2_g11784.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11785 ) , 0.0 ) ) ) );
				float2 temp_output_65_0_g11782 = shaderPosition235;
				float linValue16_g11783 = tex2D( _UberNoiseTexture, ( temp_output_65_0_g11782 * _InkSpreadNoiseScale ) ).r;
				float localMyCustomExpression16_g11783 = MyCustomExpression16_g11783( linValue16_g11783 );
				float clampResult53_g11782 = clamp( ( ( ( _InkSpreadDistance - distance( _InkSpreadPosition , temp_output_65_0_g11782 ) ) + ( localMyCustomExpression16_g11783 * _InkSpreadNoiseFactor ) ) / max( _InkSpreadWidth , 0.001 ) ) , 0.0 , 1.0 );
				float3 lerpResult7_g11782 = lerp( (temp_output_1_0_g11782).rgb , ( (_InkSpreadColor).rgb * pow( saferPower7_g11785 , temp_output_9_0_g11785 ) ) , ( _InkSpreadFade * clampResult53_g11782 ));
				float4 appendResult9_g11782 = (float4(lerpResult7_g11782 , (temp_output_1_0_g11782).a));
				float4 staticSwitch17_g11761 = appendResult9_g11782;
				#else
				float4 staticSwitch17_g11761 = staticSwitch20_g11761;
				#endif
				float temp_output_39_0_g11761 = shaderTime237;
				#ifdef _ENABLESHIFTHUE_ON
				float4 temp_output_1_0_g11776 = staticSwitch17_g11761;
				float3 hsvTorgb15_g11776 = RGBToHSV( (temp_output_1_0_g11776).rgb );
				float3 hsvTorgb19_g11776 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _ShiftHueSpeed ) + hsvTorgb15_g11776.x ),hsvTorgb15_g11776.y,hsvTorgb15_g11776.z) );
				float4 appendResult6_g11776 = (float4(hsvTorgb19_g11776 , temp_output_1_0_g11776.a));
				float4 staticSwitch19_g11761 = appendResult6_g11776;
				#else
				float4 staticSwitch19_g11761 = staticSwitch17_g11761;
				#endif
				#ifdef _ENABLEADDHUE_ON
				float3 hsvTorgb19_g11779 = HSVToRGB( float3(( ( temp_output_39_0_g11761 * _AddHueSpeed ) % 1.0 ),_AddHueSaturation,_AddHueBrightness) );
				float4 temp_output_1_0_g11779 = staticSwitch19_g11761;
				float4 break2_g11781 = temp_output_1_0_g11779;
				float saferPower27_g11779 = abs( ( ( break2_g11781.x + break2_g11781.x + break2_g11781.y + break2_g11781.y + break2_g11781.y + break2_g11781.z ) / 6.0 ) );
				float2 uv_AddHueMask = IN.ase_texcoord5.xy * _AddHueMask_ST.xy + _AddHueMask_ST.zw;
				float4 tex2DNode3_g11780 = tex2D( _AddHueMask, uv_AddHueMask );
				#ifdef _ADDHUEMASKTOGGLE_ON
				float staticSwitch33_g11779 = ( _AddHueFade * ( tex2DNode3_g11780.r * tex2DNode3_g11780.a ) );
				#else
				float staticSwitch33_g11779 = _AddHueFade;
				#endif
				float4 appendResult6_g11779 = (float4(( ( hsvTorgb19_g11779 * pow( saferPower27_g11779 , max( _AddHueContrast , 0.001 ) ) * staticSwitch33_g11779 ) + (temp_output_1_0_g11779).rgb ) , temp_output_1_0_g11779.a));
				float4 staticSwitch23_g11761 = appendResult6_g11779;
				#else
				float4 staticSwitch23_g11761 = staticSwitch19_g11761;
				#endif
				#ifdef _ENABLESINEGLOW_ON
				float4 temp_output_1_0_g11777 = staticSwitch23_g11761;
				float4 break2_g11778 = temp_output_1_0_g11777;
				float3 temp_output_13_0_g11777 = (_SineGlowColor).rgb;
				float2 uv_SineGlowMask = IN.ase_texcoord5.xy * _SineGlowMask_ST.xy + _SineGlowMask_ST.zw;
				float4 tex2DNode30_g11777 = tex2D( _SineGlowMask, uv_SineGlowMask );
				#ifdef _SINEGLOWMASKTOGGLE_ON
				float3 staticSwitch27_g11777 = ( (tex2DNode30_g11777).rgb * temp_output_13_0_g11777 * tex2DNode30_g11777.a );
				#else
				float3 staticSwitch27_g11777 = temp_output_13_0_g11777;
				#endif
				float4 appendResult21_g11777 = (float4(( (temp_output_1_0_g11777).rgb + ( pow( ( ( break2_g11778.x + break2_g11778.x + break2_g11778.y + break2_g11778.y + break2_g11778.y + break2_g11778.z ) / 6.0 ) , max( _SineGlowContrast , 0.0 ) ) * staticSwitch27_g11777 * _SineGlowFade * ( ( ( sin( ( temp_output_39_0_g11761 * _SineGlowFrequency ) ) + 1.0 ) * ( _SineGlowMax - _SineGlowMin ) ) + _SineGlowMin ) ) ) , temp_output_1_0_g11777.a));
				float4 staticSwitch28_g11761 = appendResult21_g11777;
				#else
				float4 staticSwitch28_g11761 = staticSwitch23_g11761;
				#endif
				#ifdef _ENABLESATURATION_ON
				float4 temp_output_1_0_g11766 = staticSwitch28_g11761;
				float4 break2_g11767 = temp_output_1_0_g11766;
				float3 temp_cast_45 = (( ( break2_g11767.x + break2_g11767.x + break2_g11767.y + break2_g11767.y + break2_g11767.y + break2_g11767.z ) / 6.0 )).xxx;
				float3 lerpResult5_g11766 = lerp( temp_cast_45 , (temp_output_1_0_g11766).rgb , _Saturation);
				float4 appendResult8_g11766 = (float4(lerpResult5_g11766 , temp_output_1_0_g11766.a));
				float4 staticSwitch38_g11761 = appendResult8_g11766;
				#else
				float4 staticSwitch38_g11761 = staticSwitch28_g11761;
				#endif
				#ifdef _ENABLEINNEROUTLINE_ON
				float4 temp_output_15_0_g11768 = staticSwitch38_g11761;
				float3 temp_output_82_0_g11768 = (_InnerOutlineColor).rgb;
				float2 temp_output_7_0_g11768 = temp_output_1_0_g11761;
				float temp_output_179_0_g11768 = temp_output_39_0_g11761;
				#ifdef _INNEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch187_g11768 = ( (tex2D( _InnerOutlineTintTexture, ( temp_output_7_0_g11768 + ( _InnerOutlineTextureSpeed * temp_output_179_0_g11768 ) ) )).rgb * temp_output_82_0_g11768 );
				#else
				float3 staticSwitch187_g11768 = temp_output_82_0_g11768;
				#endif
				float linValue16_g11770 = tex2D( _UberNoiseTexture, ( ( ( temp_output_179_0_g11768 * _InnerOutlineNoiseSpeed ) + temp_output_7_0_g11768 ) * _InnerOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11770 = MyCustomExpression16_g11770( linValue16_g11770 );
				#ifdef _INNEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch169_g11768 = ( ( localMyCustomExpression16_g11770 - 0.5 ) * _InnerOutlineDistortionIntensity );
				#else
				float2 staticSwitch169_g11768 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11768 = ( staticSwitch169_g11768 + temp_output_7_0_g11768 );
				float2 appendResult2_g11769 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11768 = ( 100.0 / appendResult2_g11769 );
				float temp_output_178_0_g11768 = ( _InnerOutlineFade * ( 1.0 - min( min( min( min( min( min( min( tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11768 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11768 + ( ( _InnerOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11768 ) ) ).a ) ) );
				float3 lerpResult176_g11768 = lerp( (temp_output_15_0_g11768).rgb , staticSwitch187_g11768 , temp_output_178_0_g11768);
				#ifdef _INNEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch188_g11768 = ( temp_output_178_0_g11768 * temp_output_15_0_g11768.a );
				#else
				float staticSwitch188_g11768 = temp_output_15_0_g11768.a;
				#endif
				float4 appendResult177_g11768 = (float4(lerpResult176_g11768 , staticSwitch188_g11768));
				float4 staticSwitch12_g11761 = appendResult177_g11768;
				#else
				float4 staticSwitch12_g11761 = staticSwitch38_g11761;
				#endif
				#ifdef _ENABLEOUTEROUTLINE_ON
				float4 temp_output_15_0_g11793 = staticSwitch12_g11761;
				float3 temp_output_82_0_g11793 = (_OuterOutlineColor).rgb;
				float2 temp_output_7_0_g11793 = temp_output_1_0_g11761;
				float temp_output_186_0_g11793 = temp_output_39_0_g11761;
				#ifdef _OUTEROUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11793 = ( (tex2D( _OuterOutlineTintTexture, ( temp_output_7_0_g11793 + ( _OuterOutlineTextureSpeed * temp_output_186_0_g11793 ) ) )).rgb * temp_output_82_0_g11793 );
				#else
				float3 staticSwitch199_g11793 = temp_output_82_0_g11793;
				#endif
				float temp_output_182_0_g11793 = ( ( 1.0 - temp_output_15_0_g11793.a ) * min( ( _OuterOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11793 = 1.0;
				#else
				float staticSwitch203_g11793 = temp_output_182_0_g11793;
				#endif
				float3 lerpResult178_g11793 = lerp( (temp_output_15_0_g11793).rgb , staticSwitch199_g11793 , staticSwitch203_g11793);
				float3 lerpResult170_g11793 = lerp( lerpResult178_g11793 , staticSwitch199_g11793 , staticSwitch203_g11793);
				float linValue16_g11794 = tex2D( _UberNoiseTexture, ( ( ( temp_output_186_0_g11793 * _OuterOutlineNoiseSpeed ) + temp_output_7_0_g11793 ) * _OuterOutlineNoiseScale ) ).r;
				float localMyCustomExpression16_g11794 = MyCustomExpression16_g11794( linValue16_g11794 );
				#ifdef _OUTEROUTLINEDISTORTIONTOGGLE_ON
				float2 staticSwitch157_g11793 = ( ( localMyCustomExpression16_g11794 - 0.5 ) * _OuterOutlineDistortionIntensity );
				#else
				float2 staticSwitch157_g11793 = float2( 0,0 );
				#endif
				float2 temp_output_131_0_g11793 = ( staticSwitch157_g11793 + temp_output_7_0_g11793 );
				float2 appendResult2_g11795 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_25_0_g11793 = ( 100.0 / appendResult2_g11795 );
				float lerpResult168_g11793 = lerp( temp_output_15_0_g11793.a , min( ( max( max( max( max( max( max( max( tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,-1 ) ) * temp_output_25_0_g11793 ) ) ).a , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0,1 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 1,0 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( 0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) , tex2D( _MainTex, ( temp_output_131_0_g11793 + ( ( _OuterOutlineWidth * float2( -0.705,-0.705 ) ) * temp_output_25_0_g11793 ) ) ).a ) * 3.0 ) , 1.0 ) , _OuterOutlineFade);
				#ifdef _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11793 = ( temp_output_182_0_g11793 * lerpResult168_g11793 );
				#else
				float staticSwitch200_g11793 = lerpResult168_g11793;
				#endif
				float4 appendResult174_g11793 = (float4(lerpResult170_g11793 , staticSwitch200_g11793));
				float4 staticSwitch13_g11761 = appendResult174_g11793;
				#else
				float4 staticSwitch13_g11761 = staticSwitch12_g11761;
				#endif
				#ifdef _ENABLEPIXELOUTLINE_ON
				float4 temp_output_15_0_g11772 = staticSwitch13_g11761;
				float3 temp_output_82_0_g11772 = (_PixelOutlineColor).rgb;
				float2 temp_output_7_0_g11772 = temp_output_1_0_g11761;
				#ifdef _PIXELOUTLINETEXTURETOGGLE_ON
				float3 staticSwitch199_g11772 = ( (tex2D( _PixelOutlineTintTexture, ( temp_output_7_0_g11772 + ( _PixelOutlineTextureSpeed * temp_output_39_0_g11761 ) ) )).rgb * temp_output_82_0_g11772 );
				#else
				float3 staticSwitch199_g11772 = temp_output_82_0_g11772;
				#endif
				float temp_output_182_0_g11772 = ( ( 1.0 - temp_output_15_0_g11772.a ) * min( ( _PixelOutlineFade * 3.0 ) , 1.0 ) );
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch203_g11772 = 1.0;
				#else
				float staticSwitch203_g11772 = temp_output_182_0_g11772;
				#endif
				float3 lerpResult178_g11772 = lerp( (temp_output_15_0_g11772).rgb , staticSwitch199_g11772 , staticSwitch203_g11772);
				float3 lerpResult170_g11772 = lerp( lerpResult178_g11772 , staticSwitch199_g11772 , staticSwitch203_g11772);
				float2 appendResult206_g11772 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float2 temp_output_209_0_g11772 = ( float2( 1,1 ) / appendResult206_g11772 );
				float lerpResult168_g11772 = lerp( temp_output_15_0_g11772.a , min( ( max( max( max( tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,-1 ) ) * temp_output_209_0_g11772 ) ) ).a , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 0,1 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( -1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) , tex2D( _MainTex, ( temp_output_7_0_g11772 + ( ( _PixelOutlineWidth * float2( 1,0 ) ) * temp_output_209_0_g11772 ) ) ).a ) * 3.0 ) , 1.0 ) , _PixelOutlineFade);
				#ifdef _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
				float staticSwitch200_g11772 = ( temp_output_182_0_g11772 * lerpResult168_g11772 );
				#else
				float staticSwitch200_g11772 = lerpResult168_g11772;
				#endif
				float4 appendResult174_g11772 = (float4(lerpResult170_g11772 , staticSwitch200_g11772));
				float4 staticSwitch48_g11761 = appendResult174_g11772;
				#else
				float4 staticSwitch48_g11761 = staticSwitch13_g11761;
				#endif
				#ifdef _ENABLEPINGPONGGLOW_ON
				float3 lerpResult15_g11762 = lerp( (_PingPongGlowFrom).rgb , (_PingPongGlowTo).rgb , ( ( sin( ( temp_output_39_0_g11761 * _PingPongGlowFrequency ) ) + 1.0 ) / 2.0 ));
				float4 temp_output_5_0_g11762 = staticSwitch48_g11761;
				float4 break2_g11763 = temp_output_5_0_g11762;
				float4 appendResult12_g11762 = (float4(( ( lerpResult15_g11762 * _PingPongGlowFade * pow( ( ( break2_g11763.x + break2_g11763.x + break2_g11763.y + break2_g11763.y + break2_g11763.y + break2_g11763.z ) / 6.0 ) , max( _PingPongGlowContrast , 0.0 ) ) ) + (temp_output_5_0_g11762).rgb ) , temp_output_5_0_g11762.a));
				float4 staticSwitch46_g11761 = appendResult12_g11762;
				#else
				float4 staticSwitch46_g11761 = staticSwitch48_g11761;
				#endif
				float4 temp_output_361_0 = staticSwitch46_g11761;
				#ifdef _ENABLEHOLOGRAM_ON
				float4 temp_output_1_0_g11797 = temp_output_361_0;
				float4 break2_g11798 = temp_output_1_0_g11797;
				float temp_output_9_0_g11799 = max( _HologramContrast , 0.0 );
				float saferPower7_g11799 = abs( ( ( ( break2_g11798.x + break2_g11798.x + break2_g11798.y + break2_g11798.y + break2_g11798.y + break2_g11798.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11799 ) , 0.0 ) ) ) );
				float4 appendResult22_g11797 = (float4(( (_HologramTint).rgb * pow( saferPower7_g11799 , temp_output_9_0_g11799 ) ) , ( max( pow( abs( sin( ( ( ( ( shaderTime237 * _HologramLineSpeed ) + WorldPosition.y ) / unity_OrthoParams.y ) * _HologramLineFrequency ) ) ) , _HologramLineGap ) , _HologramMinAlpha ) * temp_output_1_0_g11797.a )));
				float4 lerpResult37_g11797 = lerp( temp_output_1_0_g11797 , appendResult22_g11797 , hologramFade182);
				float4 staticSwitch56 = lerpResult37_g11797;
				#else
				float4 staticSwitch56 = temp_output_361_0;
				#endif
				#ifdef _ENABLEGLITCH_ON
				float4 temp_output_1_0_g11800 = staticSwitch56;
				float4 break2_g11802 = temp_output_1_0_g11800;
				float temp_output_34_0_g11800 = shaderTime237;
				float linValue16_g11801 = tex2D( _UberNoiseTexture, ( ( glitchPosition154 + ( _GlitchNoiseSpeed * temp_output_34_0_g11800 ) ) * _GlitchNoiseScale ) ).r;
				float localMyCustomExpression16_g11801 = MyCustomExpression16_g11801( linValue16_g11801 );
				float3 hsvTorgb3_g11803 = HSVToRGB( float3(( localMyCustomExpression16_g11801 + ( temp_output_34_0_g11800 * _GlitchHueSpeed ) ),1.0,1.0) );
				float3 lerpResult23_g11800 = lerp( (temp_output_1_0_g11800).rgb , ( ( ( break2_g11802.x + break2_g11802.x + break2_g11802.y + break2_g11802.y + break2_g11802.y + break2_g11802.z ) / 6.0 ) * _GlitchBrightness * hsvTorgb3_g11803 ) , glitchFade152);
				float4 appendResult27_g11800 = (float4(lerpResult23_g11800 , temp_output_1_0_g11800.a));
				float4 staticSwitch57 = appendResult27_g11800;
				#else
				float4 staticSwitch57 = staticSwitch56;
				#endif
				float4 temp_output_3_0_g11804 = staticSwitch57;
				float4 temp_output_1_0_g11829 = temp_output_3_0_g11804;
				float2 temp_output_41_0_g11804 = shaderPosition235;
				float2 temp_output_99_0_g11829 = temp_output_41_0_g11804;
				float temp_output_40_0_g11804 = shaderTime237;
				#ifdef _ENABLECAMOUFLAGE_ON
				float linValue16_g11834 = tex2D( _UberNoiseTexture, ( ( ( temp_output_40_0_g11804 * _CamouflageDistortionSpeed ) + temp_output_99_0_g11829 ) * _CamouflageDistortionScale ) ).r;
				float localMyCustomExpression16_g11834 = MyCustomExpression16_g11834( linValue16_g11834 );
				#ifdef _CAMOUFLAGEANIMATIONTOGGLE_ON
				float2 staticSwitch101_g11829 = ( ( ( localMyCustomExpression16_g11834 - 0.25 ) * _CamouflageDistortionIntensity ) + temp_output_99_0_g11829 );
				#else
				float2 staticSwitch101_g11829 = temp_output_99_0_g11829;
				#endif
				float linValue16_g11831 = tex2D( _UberNoiseTexture, ( staticSwitch101_g11829 * _CamouflageNoiseScaleA ) ).r;
				float localMyCustomExpression16_g11831 = MyCustomExpression16_g11831( linValue16_g11831 );
				float clampResult52_g11829 = clamp( ( ( _CamouflageDensityA - localMyCustomExpression16_g11831 ) / max( _CamouflageSmoothnessA , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult55_g11829 = lerp( _CamouflageBaseColor , ( _CamouflageColorA * clampResult52_g11829 ) , clampResult52_g11829);
				float linValue16_g11833 = tex2D( _UberNoiseTexture, ( ( staticSwitch101_g11829 + float2( 12.3,12.3 ) ) * _CamouflageNoiseScaleB ) ).r;
				float localMyCustomExpression16_g11833 = MyCustomExpression16_g11833( linValue16_g11833 );
				float clampResult65_g11829 = clamp( ( ( _CamouflageDensityB - localMyCustomExpression16_g11833 ) / max( _CamouflageSmoothnessB , 0.005 ) ) , 0.0 , 1.0 );
				float4 lerpResult68_g11829 = lerp( lerpResult55_g11829 , ( _CamouflageColorB * clampResult65_g11829 ) , clampResult65_g11829);
				float4 break2_g11832 = temp_output_1_0_g11829;
				float temp_output_9_0_g11830 = max( _CamouflageContrast , 0.0 );
				float saferPower7_g11830 = abs( ( ( ( break2_g11832.x + break2_g11832.x + break2_g11832.y + break2_g11832.y + break2_g11832.y + break2_g11832.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11830 ) , 0.0 ) ) ) );
				float3 lerpResult4_g11829 = lerp( (temp_output_1_0_g11829).rgb , ( (lerpResult68_g11829).rgb * pow( saferPower7_g11830 , temp_output_9_0_g11830 ) ) , _CamouflageFade);
				float4 appendResult7_g11829 = (float4(lerpResult4_g11829 , temp_output_1_0_g11829.a));
				float4 staticSwitch26_g11804 = appendResult7_g11829;
				#else
				float4 staticSwitch26_g11804 = temp_output_3_0_g11804;
				#endif
				#ifdef _ENABLEMETAL_ON
				float4 temp_output_1_0_g11823 = staticSwitch26_g11804;
				float temp_output_59_0_g11823 = temp_output_40_0_g11804;
				float2 temp_output_58_0_g11823 = temp_output_41_0_g11804;
				float linValue16_g11824 = tex2D( _UberNoiseTexture, ( ( ( temp_output_59_0_g11823 * _MetalNoiseDistortionSpeed ) + temp_output_58_0_g11823 ) * _MetalNoiseDistortionScale ) ).r;
				float localMyCustomExpression16_g11824 = MyCustomExpression16_g11824( linValue16_g11824 );
				float linValue16_g11826 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11824 - 0.25 ) * _MetalNoiseDistortion ) + ( ( temp_output_59_0_g11823 * _MetalNoiseSpeed ) + temp_output_58_0_g11823 ) ) * _MetalNoiseScale ) ).r;
				float localMyCustomExpression16_g11826 = MyCustomExpression16_g11826( linValue16_g11826 );
				float4 break2_g11825 = temp_output_1_0_g11823;
				float temp_output_5_0_g11823 = ( ( break2_g11825.x + break2_g11825.x + break2_g11825.y + break2_g11825.y + break2_g11825.y + break2_g11825.z ) / 6.0 );
				float temp_output_9_0_g11827 = max( _MetalHighlightContrast , 0.0 );
				float saferPower7_g11827 = abs( ( temp_output_5_0_g11823 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11827 ) , 0.0 ) ) ) );
				float saferPower2_g11823 = abs( temp_output_5_0_g11823 );
				float2 uv_MetalMask = IN.ase_texcoord5.xy * _MetalMask_ST.xy + _MetalMask_ST.zw;
				float4 tex2DNode3_g11828 = tex2D( _MetalMask, uv_MetalMask );
				#ifdef _METALMASKTOGGLE_ON
				float staticSwitch60_g11823 = ( _MetalFade * ( tex2DNode3_g11828.r * tex2DNode3_g11828.a ) );
				#else
				float staticSwitch60_g11823 = _MetalFade;
				#endif
				float4 lerpResult45_g11823 = lerp( temp_output_1_0_g11823 , ( ( max( ( ( _MetalHighlightDensity - localMyCustomExpression16_g11826 ) / max( _MetalHighlightDensity , 0.01 ) ) , 0.0 ) * _MetalHighlightColor * pow( saferPower7_g11827 , temp_output_9_0_g11827 ) ) + ( pow( saferPower2_g11823 , _MetalContrast ) * _MetalColor ) ) , staticSwitch60_g11823);
				float4 appendResult8_g11823 = (float4((lerpResult45_g11823).rgb , (temp_output_1_0_g11823).a));
				float4 staticSwitch28_g11804 = appendResult8_g11823;
				#else
				float4 staticSwitch28_g11804 = staticSwitch26_g11804;
				#endif
				#ifdef _ENABLEFROZEN_ON
				float4 temp_output_1_0_g11817 = staticSwitch28_g11804;
				float4 break2_g11818 = temp_output_1_0_g11817;
				float temp_output_7_0_g11817 = ( ( break2_g11818.x + break2_g11818.x + break2_g11818.y + break2_g11818.y + break2_g11818.y + break2_g11818.z ) / 6.0 );
				float temp_output_9_0_g11820 = max( _FrozenContrast , 0.0 );
				float saferPower7_g11820 = abs( ( temp_output_7_0_g11817 + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11820 ) , 0.0 ) ) ) );
				float saferPower20_g11817 = abs( temp_output_7_0_g11817 );
				float2 temp_output_72_0_g11817 = temp_output_41_0_g11804;
				float linValue16_g11819 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11817 * _FrozenSnowScale ) ).r;
				float localMyCustomExpression16_g11819 = MyCustomExpression16_g11819( linValue16_g11819 );
				float temp_output_73_0_g11817 = temp_output_40_0_g11804;
				float linValue16_g11821 = tex2D( _UberNoiseTexture, ( ( ( temp_output_73_0_g11817 * _FrozenHighlightDistortionSpeed ) + temp_output_72_0_g11817 ) * _FrozenHighlightDistortionScale ) ).r;
				float localMyCustomExpression16_g11821 = MyCustomExpression16_g11821( linValue16_g11821 );
				float linValue16_g11822 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11821 - 0.25 ) * _FrozenHighlightDistortion ) + ( ( temp_output_73_0_g11817 * _FrozenHighlightSpeed ) + temp_output_72_0_g11817 ) ) * _FrozenHighlightScale ) ).r;
				float localMyCustomExpression16_g11822 = MyCustomExpression16_g11822( linValue16_g11822 );
				float saferPower42_g11817 = abs( temp_output_7_0_g11817 );
				float3 lerpResult57_g11817 = lerp( (temp_output_1_0_g11817).rgb , ( ( pow( saferPower7_g11820 , temp_output_9_0_g11820 ) * (_FrozenTint).rgb ) + ( pow( saferPower20_g11817 , _FrozenSnowContrast ) * ( (_FrozenSnowColor).rgb * max( ( _FrozenSnowDensity - localMyCustomExpression16_g11819 ) , 0.0 ) ) ) + (( max( ( ( _FrozenHighlightDensity - localMyCustomExpression16_g11822 ) / max( _FrozenHighlightDensity , 0.01 ) ) , 0.0 ) * _FrozenHighlightColor * pow( saferPower42_g11817 , _FrozenHighlightContrast ) )).rgb ) , _FrozenFade);
				float4 appendResult26_g11817 = (float4(lerpResult57_g11817 , temp_output_1_0_g11817.a));
				float4 staticSwitch29_g11804 = appendResult26_g11817;
				#else
				float4 staticSwitch29_g11804 = staticSwitch28_g11804;
				#endif
				#ifdef _ENABLEBURN_ON
				float4 temp_output_1_0_g11812 = staticSwitch29_g11804;
				float3 temp_output_28_0_g11812 = (temp_output_1_0_g11812).rgb;
				float4 break2_g11816 = float4( temp_output_28_0_g11812 , 0.0 );
				float saferPower21_g11812 = abs( ( ( break2_g11816.x + break2_g11816.x + break2_g11816.y + break2_g11816.y + break2_g11816.y + break2_g11816.z ) / 6.0 ) );
				float2 temp_output_72_0_g11812 = temp_output_41_0_g11804;
				float linValue16_g11815 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnSwirlNoiseScale ) ).r;
				float localMyCustomExpression16_g11815 = MyCustomExpression16_g11815( linValue16_g11815 );
				float linValue16_g11813 = tex2D( _UberNoiseTexture, ( ( ( ( localMyCustomExpression16_g11815 - 0.5 ) * float2( 1,1 ) * _BurnSwirlFactor ) + temp_output_72_0_g11812 ) * _BurnInsideNoiseScale ) ).r;
				float localMyCustomExpression16_g11813 = MyCustomExpression16_g11813( linValue16_g11813 );
				float clampResult68_g11812 = clamp( ( _BurnInsideNoiseFactor - localMyCustomExpression16_g11813 ) , 0.0 , 1.0 );
				float linValue16_g11814 = tex2D( _UberNoiseTexture, ( temp_output_72_0_g11812 * _BurnEdgeNoiseScale ) ).r;
				float localMyCustomExpression16_g11814 = MyCustomExpression16_g11814( linValue16_g11814 );
				float temp_output_15_0_g11812 = ( ( ( _BurnRadius - distance( temp_output_72_0_g11812 , _BurnPosition ) ) + ( localMyCustomExpression16_g11814 * _BurnEdgeNoiseFactor ) ) / max( _BurnWidth , 0.01 ) );
				float clampResult18_g11812 = clamp( temp_output_15_0_g11812 , 0.0 , 1.0 );
				float3 lerpResult29_g11812 = lerp( temp_output_28_0_g11812 , ( pow( saferPower21_g11812 , max( _BurnInsideContrast , 0.001 ) ) * ( ( (_BurnInsideNoiseColor).rgb * clampResult68_g11812 ) + (_BurnInsideColor).rgb ) ) , clampResult18_g11812);
				float3 lerpResult40_g11812 = lerp( temp_output_28_0_g11812 , ( lerpResult29_g11812 + ( ( step( temp_output_15_0_g11812 , 1.0 ) * step( 0.0 , temp_output_15_0_g11812 ) ) * (_BurnEdgeColor).rgb ) ) , _BurnFade);
				float4 appendResult43_g11812 = (float4(lerpResult40_g11812 , temp_output_1_0_g11812.a));
				float4 staticSwitch32_g11804 = appendResult43_g11812;
				#else
				float4 staticSwitch32_g11804 = staticSwitch29_g11804;
				#endif
				#ifdef _ENABLERAINBOW_ON
				float2 temp_output_42_0_g11808 = temp_output_41_0_g11804;
				float linValue16_g11809 = tex2D( _UberNoiseTexture, ( temp_output_42_0_g11808 * _RainbowNoiseScale ) ).r;
				float localMyCustomExpression16_g11809 = MyCustomExpression16_g11809( linValue16_g11809 );
				float3 hsvTorgb3_g11811 = HSVToRGB( float3(( ( ( distance( temp_output_42_0_g11808 , _RainbowCenter ) + ( localMyCustomExpression16_g11809 * _RainbowNoiseFactor ) ) * _RainbowDensity ) + ( _RainbowSpeed * temp_output_40_0_g11804 ) ),1.0,1.0) );
				float3 hsvTorgb36_g11808 = RGBToHSV( hsvTorgb3_g11811 );
				float3 hsvTorgb37_g11808 = HSVToRGB( float3(hsvTorgb36_g11808.x,_RainbowSaturation,( hsvTorgb36_g11808.z * _RainbowBrightness )) );
				float4 temp_output_1_0_g11808 = staticSwitch32_g11804;
				float4 break2_g11810 = temp_output_1_0_g11808;
				float saferPower24_g11808 = abs( ( ( break2_g11810.x + break2_g11810.x + break2_g11810.y + break2_g11810.y + break2_g11810.y + break2_g11810.z ) / 6.0 ) );
				float4 appendResult29_g11808 = (float4(( ( hsvTorgb37_g11808 * pow( saferPower24_g11808 , max( _RainbowContrast , 0.001 ) ) * _RainbowFade ) + (temp_output_1_0_g11808).rgb ) , temp_output_1_0_g11808.a));
				float4 staticSwitch34_g11804 = appendResult29_g11808;
				#else
				float4 staticSwitch34_g11804 = staticSwitch32_g11804;
				#endif
				#ifdef _ENABLESHINE_ON
				float4 temp_output_1_0_g11805 = staticSwitch34_g11804;
				float3 temp_output_57_0_g11805 = (temp_output_1_0_g11805).rgb;
				float4 break2_g11806 = temp_output_1_0_g11805;
				float3 temp_cast_68 = (( ( break2_g11806.x + break2_g11806.x + break2_g11806.y + break2_g11806.y + break2_g11806.y + break2_g11806.z ) / 6.0 )).xxx;
				float3 lerpResult92_g11805 = lerp( temp_cast_68 , temp_output_57_0_g11805 , _ShineSaturation);
				float3 saferPower83_g11805 = abs( lerpResult92_g11805 );
				float3 temp_cast_69 = (max( _ShineContrast , 0.001 )).xxx;
				float3 rotatedValue69_g11805 = RotateAroundAxis( float3( 0,0,0 ), float3( ( _ShineFrequency * temp_output_41_0_g11804 ) ,  0.0 ), float3( 0,0,1 ), ( ( _ShineRotation / 180.0 ) * PI ) );
				float temp_output_103_0_g11805 = ( _ShineFrequency * _ShineWidth );
				float clampResult80_g11805 = clamp( ( ( sin( ( rotatedValue69_g11805.x - ( temp_output_40_0_g11804 * _ShineSpeed * _ShineFrequency ) ) ) - ( 1.0 - temp_output_103_0_g11805 ) ) / temp_output_103_0_g11805 ) , 0.0 , 1.0 );
				float2 uv_ShineMask = IN.ase_texcoord5.xy * _ShineMask_ST.xy + _ShineMask_ST.zw;
				float4 tex2DNode3_g11807 = tex2D( _ShineMask, uv_ShineMask );
				#ifdef _SHINEMASKTOGGLE_ON
				float staticSwitch98_g11805 = ( _ShineFade * ( tex2DNode3_g11807.r * tex2DNode3_g11807.a ) );
				#else
				float staticSwitch98_g11805 = _ShineFade;
				#endif
				float4 appendResult8_g11805 = (float4(( temp_output_57_0_g11805 + ( ( pow( saferPower83_g11805 , temp_cast_69 ) * (_ShineColor).rgb ) * clampResult80_g11805 * staticSwitch98_g11805 ) ) , (temp_output_1_0_g11805).a));
				float4 staticSwitch36_g11804 = appendResult8_g11805;
				#else
				float4 staticSwitch36_g11804 = staticSwitch34_g11804;
				#endif
				#ifdef _ENABLEPOISON_ON
				float temp_output_41_0_g11835 = temp_output_40_0_g11804;
				float linValue16_g11837 = tex2D( _UberNoiseTexture, ( ( ( temp_output_41_0_g11835 * _PoisonNoiseSpeed ) + temp_output_41_0_g11804 ) * _PoisonNoiseScale ) ).r;
				float localMyCustomExpression16_g11837 = MyCustomExpression16_g11837( linValue16_g11837 );
				float saferPower19_g11835 = abs( abs( ( ( ( localMyCustomExpression16_g11837 + ( temp_output_41_0_g11835 * _PoisonShiftSpeed ) ) % 1.0 ) + -0.5 ) ) );
				float3 temp_output_24_0_g11835 = (_PoisonColor).rgb;
				float4 temp_output_1_0_g11835 = staticSwitch36_g11804;
				float3 temp_output_28_0_g11835 = (temp_output_1_0_g11835).rgb;
				float4 break2_g11836 = float4( temp_output_28_0_g11835 , 0.0 );
				float3 lerpResult32_g11835 = lerp( temp_output_28_0_g11835 , ( temp_output_24_0_g11835 * ( ( break2_g11836.x + break2_g11836.x + break2_g11836.y + break2_g11836.y + break2_g11836.y + break2_g11836.z ) / 6.0 ) ) , ( _PoisonFade * _PoisonRecolorFactor ));
				float4 appendResult27_g11835 = (float4(( ( max( pow( saferPower19_g11835 , _PoisonDensity ) , 0.0 ) * temp_output_24_0_g11835 * _PoisonFade * _PoisonNoiseBrightness ) + lerpResult32_g11835 ) , temp_output_1_0_g11835.a));
				float4 staticSwitch39_g11804 = appendResult27_g11835;
				#else
				float4 staticSwitch39_g11804 = staticSwitch36_g11804;
				#endif
				float4 temp_output_10_0_g11838 = staticSwitch39_g11804;
				#ifdef _ENABLEENCHANTED_ON
				float3 temp_output_12_0_g11838 = (temp_output_10_0_g11838).rgb;
				float2 temp_output_2_0_g11838 = temp_output_41_0_g11804;
				float temp_output_1_0_g11838 = temp_output_40_0_g11804;
				float2 temp_output_6_0_g11838 = ( temp_output_1_0_g11838 * _EnchantedSpeed );
				float linValue16_g11841 = tex2D( _UberNoiseTexture, ( ( ( temp_output_2_0_g11838 - ( ( temp_output_6_0_g11838 + float2( 1.234,5.6789 ) ) * float2( 0.95,1.05 ) ) ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11841 = MyCustomExpression16_g11841( linValue16_g11841 );
				float linValue16_g11839 = tex2D( _UberNoiseTexture, ( ( ( temp_output_6_0_g11838 + temp_output_2_0_g11838 ) * _EnchantedScale ) * float2( 1,1 ) ) ).r;
				float localMyCustomExpression16_g11839 = MyCustomExpression16_g11839( linValue16_g11839 );
				float temp_output_36_0_g11838 = ( localMyCustomExpression16_g11841 + localMyCustomExpression16_g11839 );
				float temp_output_43_0_g11838 = ( temp_output_36_0_g11838 * 0.5 );
				float3 lerpResult42_g11838 = lerp( (_EnchantedLowColor).rgb , (_EnchantedHighColor).rgb , temp_output_43_0_g11838);
				float3 hsvTorgb53_g11838 = HSVToRGB( float3(( ( temp_output_43_0_g11838 * _EnchantedRainbowDensity ) + ( _EnchantedRainbowSpeed * temp_output_1_0_g11838 ) ),_EnchantedRainbowSaturation,1.0) );
				#ifdef _ENCHANTEDRAINBOWTOGGLE_ON
				float3 staticSwitch50_g11838 = hsvTorgb53_g11838;
				#else
				float3 staticSwitch50_g11838 = lerpResult42_g11838;
				#endif
				float4 break2_g11840 = temp_output_10_0_g11838;
				float saferPower24_g11838 = abs( ( ( break2_g11840.x + break2_g11840.x + break2_g11840.y + break2_g11840.y + break2_g11840.y + break2_g11840.z ) / 6.0 ) );
				float3 temp_output_40_0_g11838 = ( staticSwitch50_g11838 * pow( saferPower24_g11838 , _EnchantedContrast ) * _EnchantedBrightness );
				float temp_output_45_0_g11838 = ( max( ( temp_output_36_0_g11838 - _EnchantedReduce ) , 0.0 ) * _EnchantedFade );
				float3 lerpResult44_g11838 = lerp( temp_output_12_0_g11838 , temp_output_40_0_g11838 , temp_output_45_0_g11838);
				#ifdef _ENCHANTEDLERPTOGGLE_ON
				float3 staticSwitch47_g11838 = lerpResult44_g11838;
				#else
				float3 staticSwitch47_g11838 = ( temp_output_12_0_g11838 + ( temp_output_40_0_g11838 * temp_output_45_0_g11838 ) );
				#endif
				float4 appendResult19_g11838 = (float4(staticSwitch47_g11838 , temp_output_10_0_g11838.a));
				float4 staticSwitch11_g11838 = appendResult19_g11838;
				#else
				float4 staticSwitch11_g11838 = temp_output_10_0_g11838;
				#endif
				float4 temp_output_1_0_g11842 = staticSwitch11_g11838;
				#ifdef _ENABLESHIFTING_ON
				float4 break5_g11842 = temp_output_1_0_g11842;
				float3 appendResult32_g11842 = (float3(break5_g11842.r , break5_g11842.g , break5_g11842.b));
				float4 break2_g11843 = temp_output_1_0_g11842;
				float temp_output_4_0_g11842 = ( ( break2_g11843.x + break2_g11843.x + break2_g11843.y + break2_g11843.y + break2_g11843.y + break2_g11843.z ) / 6.0 );
				float temp_output_11_0_g11842 = ( ( ( temp_output_4_0_g11842 + ( temp_output_40_0_g11804 * _ShiftingSpeed ) ) * _ShiftingDensity ) % 1.0 );
				float3 lerpResult20_g11842 = lerp( (_ShiftingColorA).rgb , (_ShiftingColorB).rgb , ( abs( ( temp_output_11_0_g11842 - 0.5 ) ) * 2.0 ));
				float3 hsvTorgb12_g11842 = HSVToRGB( float3(temp_output_11_0_g11842,_ShiftingSaturation,_ShiftingBrightness) );
				#ifdef _SHIFTINGRAINBOWTOGGLE_ON
				float3 staticSwitch26_g11842 = hsvTorgb12_g11842;
				#else
				float3 staticSwitch26_g11842 = ( lerpResult20_g11842 * _ShiftingBrightness );
				#endif
				float3 lerpResult31_g11842 = lerp( appendResult32_g11842 , ( staticSwitch26_g11842 * pow( temp_output_4_0_g11842 , _ShiftingContrast ) ) , _ShiftingFade);
				float4 appendResult6_g11842 = (float4(lerpResult31_g11842 , break5_g11842.a));
				float4 staticSwitch33_g11842 = appendResult6_g11842;
				#else
				float4 staticSwitch33_g11842 = temp_output_1_0_g11842;
				#endif
				float4 temp_output_473_0 = staticSwitch33_g11842;
				#ifdef _ENABLEFULLDISTORTION_ON
				float4 break4_g11844 = temp_output_473_0;
				float fullDistortionAlpha164 = _FullDistortionFade;
				float4 appendResult5_g11844 = (float4(break4_g11844.r , break4_g11844.g , break4_g11844.b , ( break4_g11844.a * fullDistortionAlpha164 )));
				float4 staticSwitch77 = appendResult5_g11844;
				#else
				float4 staticSwitch77 = temp_output_473_0;
				#endif
				#ifdef _ENABLEDIRECTIONALDISTORTION_ON
				float4 break4_g11845 = staticSwitch77;
				float directionalDistortionAlpha167 = (( _DirectionalDistortionInvert )?( ( 1.0 - clampResult154_g11671 ) ):( clampResult154_g11671 ));
				float4 appendResult5_g11845 = (float4(break4_g11845.r , break4_g11845.g , break4_g11845.b , ( break4_g11845.a * directionalDistortionAlpha167 )));
				float4 staticSwitch75 = appendResult5_g11845;
				#else
				float4 staticSwitch75 = staticSwitch77;
				#endif
				float4 temp_output_1_0_g11846 = staticSwitch75;
				float4 temp_output_1_0_g11847 = temp_output_1_0_g11846;
#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float temp_output_53_0_g11847 = max( _FullAlphaDissolveWidth , 0.001 );
				#endif
				float2 temp_output_18_0_g11846 = shaderPosition235;
				#ifdef _ENABLEFULLALPHADISSOLVE_ON
				float linValue16_g11848 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11848 = MyCustomExpression16_g11848( linValue16_g11848 );
				float clampResult17_g11847 = clamp( ( ( ( _FullAlphaDissolveFade * ( 1.0 + temp_output_53_0_g11847 ) ) - localMyCustomExpression16_g11848 ) / temp_output_53_0_g11847 ) , 0.0 , 1.0 );
				float4 appendResult3_g11847 = (float4((temp_output_1_0_g11847).rgb , ( temp_output_1_0_g11847.a * clampResult17_g11847 )));
				float4 staticSwitch3_g11846 = appendResult3_g11847;
				#else
				float4 staticSwitch3_g11846 = temp_output_1_0_g11846;
				#endif
				#ifdef _ENABLEFULLGLOWDISSOLVE_ON
				float linValue16_g11856 = tex2D( _UberNoiseTexture, ( temp_output_18_0_g11846 * _FullGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11856 = MyCustomExpression16_g11856( linValue16_g11856 );
				float temp_output_5_0_g11855 = localMyCustomExpression16_g11856;
				float temp_output_61_0_g11855 = step( temp_output_5_0_g11855 , _FullGlowDissolveFade );
				float temp_output_53_0_g11855 = max( ( _FullGlowDissolveFade * _FullGlowDissolveWidth ) , 0.001 );
				float4 temp_output_1_0_g11855 = staticSwitch3_g11846;
				float4 appendResult3_g11855 = (float4(( ( (_FullGlowDissolveEdgeColor).rgb * ( temp_output_61_0_g11855 - step( temp_output_5_0_g11855 , ( ( _FullGlowDissolveFade * ( 1.01 + temp_output_53_0_g11855 ) ) - temp_output_53_0_g11855 ) ) ) ) + (temp_output_1_0_g11855).rgb ) , ( temp_output_1_0_g11855.a * temp_output_61_0_g11855 )));
				float4 staticSwitch5_g11846 = appendResult3_g11855;
				#else
				float4 staticSwitch5_g11846 = staticSwitch3_g11846;
				#endif
				#ifdef _ENABLESOURCEALPHADISSOLVE_ON
				float4 temp_output_1_0_g11857 = staticSwitch5_g11846;
				float2 temp_output_76_0_g11857 = temp_output_18_0_g11846;
				float linValue16_g11858 = tex2D( _UberNoiseTexture, ( temp_output_76_0_g11857 * _SourceAlphaDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11858 = MyCustomExpression16_g11858( linValue16_g11858 );
				float clampResult17_g11857 = clamp( ( ( _SourceAlphaDissolveFade - ( distance( _SourceAlphaDissolvePosition , temp_output_76_0_g11857 ) + ( localMyCustomExpression16_g11858 * _SourceAlphaDissolveNoiseFactor ) ) ) / max( _SourceAlphaDissolveWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11857 = (float4((temp_output_1_0_g11857).rgb , ( temp_output_1_0_g11857.a * (( _SourceAlphaDissolveInvert )?( ( 1.0 - clampResult17_g11857 ) ):( clampResult17_g11857 )) )));
				float4 staticSwitch8_g11846 = appendResult3_g11857;
				#else
				float4 staticSwitch8_g11846 = staticSwitch5_g11846;
				#endif
				#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
				float2 temp_output_90_0_g11853 = temp_output_18_0_g11846;
				float linValue16_g11854 = tex2D( _UberNoiseTexture, ( temp_output_90_0_g11853 * _SourceGlowDissolveNoiseScale ) ).r;
				float localMyCustomExpression16_g11854 = MyCustomExpression16_g11854( linValue16_g11854 );
				float temp_output_65_0_g11853 = ( distance( _SourceGlowDissolvePosition , temp_output_90_0_g11853 ) + ( localMyCustomExpression16_g11854 * _SourceGlowDissolveNoiseFactor ) );
				float temp_output_75_0_g11853 = step( temp_output_65_0_g11853 , _SourceGlowDissolveFade );
				float temp_output_76_0_g11853 = step( temp_output_65_0_g11853 , ( _SourceGlowDissolveFade - max( _SourceGlowDissolveWidth , 0.001 ) ) );
				float4 temp_output_1_0_g11853 = staticSwitch8_g11846;
				float4 appendResult3_g11853 = (float4(( ( max( ( temp_output_75_0_g11853 - temp_output_76_0_g11853 ) , 0.0 ) * (_SourceGlowDissolveEdgeColor).rgb ) + (temp_output_1_0_g11853).rgb ) , ( temp_output_1_0_g11853.a * (( _SourceGlowDissolveInvert )?( ( 1.0 - temp_output_76_0_g11853 ) ):( temp_output_75_0_g11853 )) )));
				float4 staticSwitch9_g11846 = appendResult3_g11853;
				#else
				float4 staticSwitch9_g11846 = staticSwitch8_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
				float4 temp_output_1_0_g11849 = staticSwitch9_g11846;
				float2 temp_output_161_0_g11849 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11849 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_161_0_g11849 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalAlphaFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11849 = rotatedValue136_g11849;
				float linValue16_g11850 = tex2D( _UberNoiseTexture, ( temp_output_161_0_g11849 * _DirectionalAlphaFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11850 = MyCustomExpression16_g11850( linValue16_g11850 );
				float clampResult154_g11849 = clamp( ( ( break130_g11849.x + break130_g11849.y + _DirectionalAlphaFadeFade + ( localMyCustomExpression16_g11850 * _DirectionalAlphaFadeNoiseFactor ) ) / max( _DirectionalAlphaFadeWidth , 0.001 ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11849 = (float4((temp_output_1_0_g11849).rgb , ( temp_output_1_0_g11849.a * (( _DirectionalAlphaFadeInvert )?( ( 1.0 - clampResult154_g11849 ) ):( clampResult154_g11849 )) )));
				float4 staticSwitch11_g11846 = appendResult3_g11849;
				#else
				float4 staticSwitch11_g11846 = staticSwitch9_g11846;
				#endif
				#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
				float2 temp_output_171_0_g11851 = temp_output_18_0_g11846;
				float3 rotatedValue136_g11851 = RotateAroundAxis( float3( 0,0,0 ), float3( temp_output_171_0_g11851 ,  0.0 ), float3( 0,0,1 ), ( ( ( _DirectionalGlowFadeRotation / 180.0 ) + -0.25 ) * PI ) );
				float3 break130_g11851 = rotatedValue136_g11851;
				float linValue16_g11852 = tex2D( _UberNoiseTexture, ( temp_output_171_0_g11851 * _DirectionalGlowFadeNoiseScale ) ).r;
				float localMyCustomExpression16_g11852 = MyCustomExpression16_g11852( linValue16_g11852 );
				float temp_output_168_0_g11851 = max( ( ( break130_g11851.x + break130_g11851.y + _DirectionalGlowFadeFade + ( localMyCustomExpression16_g11852 * _DirectionalGlowFadeNoiseFactor ) ) / max( _DirectionalGlowFadeWidth , 0.001 ) ) , 0.0 );
				float temp_output_161_0_g11851 = step( 0.1 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) );
				float4 temp_output_1_0_g11851 = staticSwitch11_g11846;
				float clampResult154_g11851 = clamp( temp_output_161_0_g11851 , 0.0 , 1.0 );
				float4 appendResult3_g11851 = (float4(( ( (_DirectionalGlowFadeEdgeColor).rgb * ( temp_output_161_0_g11851 - step( 1.0 , (( _DirectionalGlowFadeInvert )?( ( 1.0 - temp_output_168_0_g11851 ) ):( temp_output_168_0_g11851 )) ) ) ) + (temp_output_1_0_g11851).rgb ) , ( temp_output_1_0_g11851.a * clampResult154_g11851 )));
				float4 staticSwitch15_g11846 = appendResult3_g11851;
				#else
				float4 staticSwitch15_g11846 = staticSwitch11_g11846;
				#endif
				#ifdef _ENABLEHALFTONE_ON
				float4 temp_output_1_0_g11859 = staticSwitch15_g11846;
				float2 temp_output_126_0_g11859 = temp_output_18_0_g11846;
				float temp_output_121_0_g11859 = max( ( ( _HalftoneFade - distance( _HalftonePosition , temp_output_126_0_g11859 ) ) / max( 0.01 , _HalftoneFadeWidth ) ) , 0.0 );
				float2 appendResult11_g11860 = (float2(temp_output_121_0_g11859 , temp_output_121_0_g11859));
				float temp_output_17_0_g11860 = length( ( (( ( abs( temp_output_126_0_g11859 ) * _HalftoneTiling ) % float2( 1,1 ) )*2.0 + -1.0) / appendResult11_g11860 ) );
				float clampResult17_g11859 = clamp( saturate( ( ( 1.0 - temp_output_17_0_g11860 ) / fwidth( temp_output_17_0_g11860 ) ) ) , 0.0 , 1.0 );
				float4 appendResult3_g11859 = (float4((temp_output_1_0_g11859).rgb , ( temp_output_1_0_g11859.a * (( _HalftoneInvert )?( ( 1.0 - clampResult17_g11859 ) ):( clampResult17_g11859 )) )));
				float4 staticSwitch13_g11846 = appendResult3_g11859;
				#else
				float4 staticSwitch13_g11846 = staticSwitch15_g11846;
				#endif
				#ifdef _ENABLEADDCOLOR_ON
				float3 temp_output_3_0_g11862 = (_AddColorColor).rgb;
				float2 uv_AddColorMask = IN.ase_texcoord5.xy * _AddColorMask_ST.xy + _AddColorMask_ST.zw;
				float4 tex2DNode19_g11862 = tex2D( _AddColorMask, uv_AddColorMask );
				#ifdef _ADDCOLORMASKTOGGLE_ON
				float3 staticSwitch16_g11862 = ( temp_output_3_0_g11862 * ( (tex2DNode19_g11862).rgb * tex2DNode19_g11862.a ) );
				#else
				float3 staticSwitch16_g11862 = temp_output_3_0_g11862;
				#endif
				float4 temp_output_1_0_g11862 = staticSwitch13_g11846;
				float4 break2_g11864 = temp_output_1_0_g11862;
				float temp_output_9_0_g11863 = max( _AddColorContrast , 0.0 );
				float saferPower7_g11863 = abs( ( ( ( break2_g11864.x + break2_g11864.x + break2_g11864.y + break2_g11864.y + break2_g11864.y + break2_g11864.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11863 ) , 0.0 ) ) ) );
				#ifdef _ADDCOLORCONTRASTTOGGLE_ON
				float3 staticSwitch17_g11862 = ( staticSwitch16_g11862 * pow( saferPower7_g11863 , temp_output_9_0_g11863 ) );
				#else
				float3 staticSwitch17_g11862 = staticSwitch16_g11862;
				#endif
				float4 appendResult6_g11862 = (float4(( ( staticSwitch17_g11862 * _AddColorFade ) + (temp_output_1_0_g11862).rgb ) , temp_output_1_0_g11862.a));
				float4 staticSwitch5_g11861 = appendResult6_g11862;
				#else
				float4 staticSwitch5_g11861 = staticSwitch13_g11846;
				#endif
				#ifdef _ENABLEALPHATINT_ON
				float4 temp_output_1_0_g11865 = staticSwitch5_g11861;
				float3 lerpResult4_g11865 = lerp( (temp_output_1_0_g11865).rgb , (_AlphaTintColor).rgb , ( ( 1.0 - temp_output_1_0_g11865.a ) * step( _AlphaTintMinAlpha , temp_output_1_0_g11865.a ) * _AlphaTintFade ));
				float4 appendResult13_g11865 = (float4(lerpResult4_g11865 , temp_output_1_0_g11865.a));
				float4 staticSwitch11_g11861 = appendResult13_g11865;
				#else
				float4 staticSwitch11_g11861 = staticSwitch5_g11861;
				#endif
				#ifdef _ENABLESTRONGTINT_ON
				float4 temp_output_1_0_g11866 = staticSwitch11_g11861;
				float3 temp_output_6_0_g11866 = (_StrongTintTint).rgb;
				float2 uv_StrongTintMask = IN.ase_texcoord5.xy * _StrongTintMask_ST.xy + _StrongTintMask_ST.zw;
				float4 tex2DNode23_g11866 = tex2D( _StrongTintMask, uv_StrongTintMask );
				#ifdef _STRONGTINTMASKTOGGLE_ON
				float3 staticSwitch21_g11866 = ( temp_output_6_0_g11866 * ( (tex2DNode23_g11866).rgb * tex2DNode23_g11866.a ) );
				#else
				float3 staticSwitch21_g11866 = temp_output_6_0_g11866;
				#endif
				float4 break2_g11868 = temp_output_1_0_g11866;
				float temp_output_9_0_g11867 = max( _StrongTintContrast , 0.0 );
				float saferPower7_g11867 = abs( ( ( ( break2_g11868.x + break2_g11868.x + break2_g11868.y + break2_g11868.y + break2_g11868.y + break2_g11868.z ) / 6.0 ) + ( 0.1 * max( ( 1.0 - temp_output_9_0_g11867 ) , 0.0 ) ) ) );
				#ifdef _STRONGTINTCONTRASTTOGGLE_ON
				float3 staticSwitch22_g11866 = ( pow( saferPower7_g11867 , temp_output_9_0_g11867 ) * staticSwitch21_g11866 );
				#else
				float3 staticSwitch22_g11866 = staticSwitch21_g11866;
				#endif
				float3 lerpResult7_g11866 = lerp( (temp_output_1_0_g11866).rgb , staticSwitch22_g11866 , _StrongTintFade);
				float4 appendResult9_g11866 = (float4(lerpResult7_g11866 , (temp_output_1_0_g11866).a));
				float4 staticSwitch7_g11861 = appendResult9_g11866;
				#else
				float4 staticSwitch7_g11861 = staticSwitch11_g11861;
				#endif
				float4 temp_output_2_0_g11869 = staticSwitch7_g11861;
				#ifdef _ENABLESHADOW_ON
				float4 break4_g11871 = temp_output_2_0_g11869;
				float3 appendResult5_g11871 = (float3(break4_g11871.r , break4_g11871.g , break4_g11871.b));
				float2 appendResult2_g11870 = (float2(_MainTex_TexelSize.z , _MainTex_TexelSize.w));
				float4 appendResult85_g11869 = (float4(_ShadowColor.r , _ShadowColor.g , _ShadowColor.b , ( _ShadowFade * tex2D( _MainTex, ( finalUV146 - ( ( 100.0 / appendResult2_g11870 ) * _ShadowOffset ) ) ).a )));
				float4 break6_g11871 = appendResult85_g11869;
				float3 appendResult7_g11871 = (float3(break6_g11871.r , break6_g11871.g , break6_g11871.b));
				float temp_output_11_0_g11871 = ( ( 1.0 - break4_g11871.a ) * break6_g11871.a );
				float temp_output_32_0_g11871 = ( break4_g11871.a + temp_output_11_0_g11871 );
				float4 appendResult18_g11871 = (float4(( ( ( appendResult5_g11871 * break4_g11871.a ) + ( appendResult7_g11871 * temp_output_11_0_g11871 ) ) * ( 1.0 / max( temp_output_32_0_g11871 , 0.01 ) ) ) , temp_output_32_0_g11871));
				float4 staticSwitch82_g11869 = appendResult18_g11871;
				#else
				float4 staticSwitch82_g11869 = temp_output_2_0_g11869;
				#endif
				float4 break4_g11872 = staticSwitch82_g11869;
				#ifdef _ENABLECUSTOMFADE_ON
				float staticSwitch8_g11752 = 1.0;
				#else
				float staticSwitch8_g11752 = IN.ase_color.a;
				#endif
				#ifdef _ENABLESMOKE_ON
				float staticSwitch9_g11752 = 1.0;
				#else
				float staticSwitch9_g11752 = staticSwitch8_g11752;
				#endif
				float customVertexAlpha193 = staticSwitch9_g11752;
				float4 appendResult5_g11872 = (float4(break4_g11872.r , break4_g11872.g , break4_g11872.b , ( break4_g11872.a * customVertexAlpha193 )));
				float4 temp_output_344_0 = appendResult5_g11872;
				float4 temp_output_1_0_g11873 = temp_output_344_0;
				float4 appendResult8_g11873 = (float4(( (temp_output_1_0_g11873).rgb * (IN.ase_color).rgb ) , temp_output_1_0_g11873.a));
				#ifdef _VERTEXTINTFIRST_ON
				float4 staticSwitch342 = temp_output_344_0;
				#else
				float4 staticSwitch342 = appendResult8_g11873;
				#endif
				float4 lerpResult125 = lerp( ( originalColor191 * IN.ase_color ) , staticSwitch342 , fullFade123);
				#if defined(_SHADERFADING_NONE)
				float4 staticSwitch143 = staticSwitch342;
				#elif defined(_SHADERFADING_FULL)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_MASK)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_DISSOLVE)
				float4 staticSwitch143 = lerpResult125;
				#elif defined(_SHADERFADING_SPREAD)
				float4 staticSwitch143 = lerpResult125;
				#else
				float4 staticSwitch143 = staticSwitch342;
				#endif
				float4 temp_output_7_0_g11880 = staticSwitch143;
				#ifdef _BAKEDMATERIAL_ON
				float4 appendResult2_g11880 = (float4(( (temp_output_7_0_g11880).rgb / max( temp_output_7_0_g11880.a , 1E-05 ) ) , temp_output_7_0_g11880.a));
				float4 staticSwitch6_g11880 = appendResult2_g11880;
				#else
				float4 staticSwitch6_g11880 = temp_output_7_0_g11880;
				#endif
				float4 temp_output_340_0 = staticSwitch6_g11880;
				

				float3 Normal = unpack3_g11881;
				float Alpha = temp_output_340_0.a;
				float AlphaClipThreshold = 0.0;
				#ifdef ASE_DEPTH_WRITE_ON
					float DepthValue = IN.clipPos.z;
				#endif

				#ifdef _ALPHATEST_ON
					clip(Alpha - AlphaClipThreshold);
				#endif

				#ifdef LOD_FADE_CROSSFADE
					LODDitheringTransition( IN.clipPos.xyz, unity_LODFade.x );
				#endif

				#ifdef ASE_DEPTH_WRITE_ON
					outputDepth = DepthValue;
				#endif

				#if defined(_GBUFFER_NORMALS_OCT)
					float2 octNormalWS = PackNormalOctQuadEncode(WorldNormal);
					float2 remappedOctNormalWS = saturate(octNormalWS * 0.5 + 0.5);
					half3 packedNormalWS = PackFloat2To888(remappedOctNormalWS);
					return half4(packedNormalWS, 0.0);
				#else
					#if defined(_NORMALMAP)
						#if _NORMAL_DROPOFF_TS
							float crossSign = (WorldTangent.w > 0.0 ? 1.0 : -1.0) * GetOddNegativeScale();
							float3 bitangent = crossSign * cross(WorldNormal.xyz, WorldTangent.xyz);
							float3 normalWS = TransformTangentToWorld(Normal, half3x3(WorldTangent.xyz, bitangent, WorldNormal.xyz));
						#elif _NORMAL_DROPOFF_OS
							float3 normalWS = TransformObjectToWorldNormal(Normal);
						#elif _NORMAL_DROPOFF_WS
							float3 normalWS = Normal;
						#endif
					#else
						float3 normalWS = WorldNormal;
					#endif
					return half4(NormalizeNormalPerPixel(normalWS), 0.0);
				#endif
			}
			ENDHLSL
		}

		
		Pass
		{
			
			Name "GBuffer"
			Tags { "LightMode"="UniversalGBuffer" }

			Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
			ZWrite On
			ZTest LEqual
			Offset 0 , 0
			ColorMask RGBA
			

			HLSLPROGRAM

			#define _NORMAL_DROPOFF_TS 1
			#pragma multi_compile_instancing
			#pragma instancing_options renderinglayer
			#pragma multi_compile_fog
			#define ASE_FOG 1
			#define _SURFACE_TYPE_TRANSPARENT 1
			#define _ALPHATEST_SHADOW_ON 1
			#define _EMISSION
			#define _ALPHATEST_ON 1
			#define _NORMALMAP 1
			#define ASE_SRP_VERSION 120106


			#pragma shader_feature_local _RECEIVE_SHADOWS_OFF
			#pragma shader_feature_local_fragment _SPECULARHIGHLIGHTS_OFF
			#pragma shader_feature_local_fragment _ENVIRONMENTREFLECTIONS_OFF

			#pragma multi_compile _ _MAIN_LIGHT_SHADOWS _MAIN_LIGHT_SHADOWS_CASCADE _MAIN_LIGHT_SHADOWS_SCREEN
			#pragma multi_compile_fragment _ _REFLECTION_PROBE_BLENDING
			#pragma multi_compile_fragment _ _REFLECTION_PROBE_BOX_PROJECTION
			#pragma multi_compile_fragment _ _SHADOWS_SOFT
			#pragma multi_compile_fragment _ _DBUFFER_MRT1 _DBUFFER_MRT2 _DBUFFER_MRT3
			#pragma multi_compile_fragment _ _LIGHT_LAYERS
			#pragma multi_compile_fragment _ _RENDER_PASS_ENABLED

			#pragma multi_compile _ LIGHTMAP_SHADOW_MIXING
			#pragma multi_compile _ SHADOWS_SHADOWMASK
			#pragma multi_compile _ DIRLIGHTMAP_COMBINED
			#pragma multi_compile _ LIGHTMAP_ON
			#pragma multi_compile _ DYNAMICLIGHTMAP_ON
			#pragma multi_compile_fragment _ _GBUFFER_NORMALS_OCT

			#pragma vertex vert
			#pragma fragment frag

			#define SHADERPASS SHADERPASS_GBUFFER

			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Color.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/Texture.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Lighting.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Input.hlsl"
			#include "Packages/com.unity.render-pipelines.core/ShaderLibrary/TextureStack.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Shadows.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/ShaderGraphFunctions.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/DBuffer.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/ShaderPass.hlsl"

			#if defined(UNITY_INSTANCING_ENABLED) && defined(_TERRAIN_INSTANCED_PERPIXEL_NORMAL)
				#define ENABLE_TERRAIN_PERPIXEL_NORMAL
			#endif

			#define ASE_NEEDS_VERT_POSITION
			#define ASE_NEEDS_FRAG_SCREEN_POSITION
			#define ASE_NEEDS_FRAG_WORLD_POSITION
			#define ASE_NEEDS_FRAG_POSITION
			#define ASE_NEEDS_FRAG_COLOR
			#pragma shader_feature_local _SHADERFADING_NONE _SHADERFADING_FULL _SHADERFADING_MASK _SHADERFADING_DISSOLVE _SHADERFADING_SPREAD
			#pragma shader_feature_local _ENABLESINESCALE_ON
			#pragma shader_feature _ENABLEVIBRATE_ON
			#pragma shader_feature _ENABLESINEMOVE_ON
			#pragma shader_feature _ENABLESQUISH_ON
			#pragma shader_feature _SPRITESHEETFIX_ON
			#pragma shader_feature_local _PIXELPERFECTUV_ON
			#pragma shader_feature _ENABLEWORLDTILING_ON
			#pragma shader_feature _ENABLESCREENTILING_ON
			#pragma shader_feature _TOGGLETIMEFREQUENCY_ON
			#pragma shader_feature _TOGGLETIMEFPS_ON
			#pragma shader_feature _TOGGLETIMESPEED_ON
			#pragma shader_feature _TOGGLEUNSCALEDTIME_ON
			#pragma shader_feature _TOGGLECUSTOMTIME_ON
			#pragma shader_feature _SHADERSPACE_UV _SHADERSPACE_UV_RAW _SHADERSPACE_OBJECT _SHADERSPACE_OBJECT_SCALED _SHADERSPACE_WORLD _SHADERSPACE_UI_GRAPHIC _SHADERSPACE_SCREEN
			#pragma shader_feature _PIXELPERFECTSPACE_ON
			#pragma shader_feature _BAKEDMATERIAL_ON
			#pragma shader_feature _VERTEXTINTFIRST_ON
			#pragma shader_feature _ENABLESHADOW_ON
			#pragma shader_feature _ENABLESTRONGTINT_ON
			#pragma shader_feature _ENABLEALPHATINT_ON
			#pragma shader_feature_local _ENABLEADDCOLOR_ON
			#pragma shader_feature_local _ENABLEHALFTONE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALGLOWFADE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALALPHAFADE_ON
			#pragma shader_feature_local _ENABLESOURCEGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLESOURCEALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLGLOWDISSOLVE_ON
			#pragma shader_feature_local _ENABLEFULLALPHADISSOLVE_ON
			#pragma shader_feature_local _ENABLEDIRECTIONALDISTORTION_ON
			#pragma shader_feature_local _ENABLEFULLDISTORTION_ON
			#pragma shader_feature _ENABLESHIFTING_ON
			#pragma shader_feature _ENABLEENCHANTED_ON
			#pragma shader_feature_local _ENABLEPOISON_ON
			#pragma shader_feature_local _ENABLESHINE_ON
			#pragma shader_feature_local _ENABLERAINBOW_ON
			#pragma shader_feature_local _ENABLEBURN_ON
			#pragma shader_feature_local _ENABLEFROZEN_ON
			#pragma shader_feature_local _ENABLEMETAL_ON
			#pragma shader_feature_local _ENABLECAMOUFLAGE_ON
			#pragma shader_feature_local _ENABLEGLITCH_ON
			#pragma shader_feature_local _ENABLEHOLOGRAM_ON
			#pragma shader_feature _ENABLEPINGPONGGLOW_ON
			#pragma shader_feature_local _ENABLEPIXELOUTLINE_ON
			#pragma shader_feature_local _ENABLEOUTEROUTLINE_ON
			#pragma shader_feature_local _ENABLEINNEROUTLINE_ON
			#pragma shader_feature_local _ENABLESATURATION_ON
			#pragma shader_feature_local _ENABLESINEGLOW_ON
			#pragma shader_feature_local _ENABLEADDHUE_ON
			#pragma shader_feature_local _ENABLESHIFTHUE_ON
			#pragma shader_feature_local _ENABLEINKSPREAD_ON
			#pragma shader_feature_local _ENABLEBLACKTINT_ON
			#pragma shader_feature_local _ENABLESPLITTONING_ON
			#pragma shader_feature_local _ENABLEHUE_ON
			#pragma shader_feature_local _ENABLEBRIGHTNESS_ON
			#pragma shader_feature_local _ENABLECONTRAST_ON
			#pragma shader_feature _ENABLENEGATIVE_ON
			#pragma shader_feature_local _ENABLECOLORREPLACE_ON
			#pragma shader_feature_local _ENABLERECOLORRGBYCP_ON
			#pragma shader_feature _ENABLERECOLORRGB_ON
			#pragma shader_feature_local _ENABLEFLAME_ON
			#pragma shader_feature_local _ENABLECHECKERBOARD_ON
			#pragma shader_feature_local _ENABLECUSTOMFADE_ON
			#pragma shader_feature_local _ENABLESMOKE_ON
			#pragma shader_feature _ENABLESHARPEN_ON
			#pragma shader_feature _ENABLEGAUSSIANBLUR_ON
			#pragma shader_feature _ENABLESMOOTHPIXELART_ON
			#pragma shader_feature_local _TILINGFIX_ON
			#pragma shader_feature _ENABLEWIGGLE_ON
			#pragma shader_feature_local _ENABLEUVSCALE_ON
			#pragma shader_feature_local _ENABLEPIXELATE_ON
			#pragma shader_feature_local _ENABLEUVSCROLL_ON
			#pragma shader_feature_local _ENABLEUVROTATE_ON
			#pragma shader_feature_local _ENABLESINEROTATE_ON
			#pragma shader_feature_local _ENABLESQUEEZE_ON
			#pragma shader_feature_local _ENABLEUVDISTORT_ON
			#pragma shader_feature_local _ENABLEWIND_ON
			#pragma shader_feature_local _WINDLOCALWIND_ON
			#pragma shader_feature_local _WINDHIGHQUALITYNOISE_ON
			#pragma shader_feature_local _WINDISPARALLAX_ON
			#pragma shader_feature _UVDISTORTMASKTOGGLE_ON
			#pragma shader_feature _WIGGLEFIXEDGROUNDTOGGLE_ON
			#pragma shader_feature _RECOLORRGBTEXTURETOGGLE_ON
			#pragma shader_feature _RECOLORRGBYCPTEXTURETOGGLE_ON
			#pragma shader_feature_local _ADDHUEMASKTOGGLE_ON
			#pragma shader_feature_local _SINEGLOWMASKTOGGLE_ON
			#pragma shader_feature _INNEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature_local _INNEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _INNEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _OUTEROUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _OUTEROUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature_local _OUTEROUTLINEDISTORTIONTOGGLE_ON
			#pragma shader_feature _PIXELOUTLINETEXTURETOGGLE_ON
			#pragma shader_feature _PIXELOUTLINEOUTLINEONLYTOGGLE_ON
			#pragma shader_feature _CAMOUFLAGEANIMATIONTOGGLE_ON
			#pragma shader_feature _METALMASKTOGGLE_ON
			#pragma shader_feature _SHINEMASKTOGGLE_ON
			#pragma shader_feature _ENCHANTEDLERPTOGGLE_ON
			#pragma shader_feature _ENCHANTEDRAINBOWTOGGLE_ON
			#pragma shader_feature _SHIFTINGRAINBOWTOGGLE_ON
			#pragma shader_feature _ADDCOLORCONTRASTTOGGLE_ON
			#pragma shader_feature _ADDCOLORMASKTOGGLE_ON
			#pragma shader_feature _STRONGTINTCONTRASTTOGGLE_ON
			#pragma shader_feature _STRONGTINTMASKTOGGLE_ON
			#pragma shader_feature _EMISSIONTOGGLE_ON
			#pragma shader_feature _METALLICMAPTOGGLE_ON


			#if defined(ASE_EARLY_Z_DEPTH_OPTIMIZE) && (SHADER_TARGET >= 45)
				#define ASE_SV_DEPTH SV_DepthLessEqual
				#define ASE_SV_POSITION_QUALIFIERS linear noperspective centroid
			#else
				#define ASE_SV_DEPTH SV_Depth
				#define ASE_SV_POSITION_QUALIFIERS
			#endif

			struct VertexInput
			{
				float4 vertex : POSITION;
				float3 ase_normal : NORMAL;
				float4 ase_tangent : TANGENT;
				float4 texcoord : TEXCOORD0;
				float4 texcoord1 : TEXCOORD1;
				float4 texcoord2 : TEXCOORD2;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
			};

			struct VertexOutput
			{
				ASE_SV_POSITION_QUALIFIERS float4 clipPos : SV_POSITION;
				float4 clipPosV : TEXCOORD0;
				float4 lightmapUVOrVertexSH : TEXCOORD1;
				half4 fogFactorAndVertexLight : TEXCOORD2;
				float4 tSpace0 : TEXCOORD3;
				float4 tSpace1 : TEXCOORD4;
				float4 tSpace2 : TEXCOORD5;
				#if defined(REQUIRES_VERTEX_SHADOW_COORD_INTERPOLATOR)
				float4 shadowCoord : TEXCOORD6;
				#endif
				#if defined(DYNAMICLIGHTMAP_ON)
				float2 dynamicLightmapUV : TEXCOORD7;
				#endif
				float4 ase_texcoord8 : TEXCOORD8;
				float4 ase_texcoord9 : TEXCOORD9;
				float4 ase_color : COLOR;
				UNITY_VERTEX_INPUT_INSTANCE_ID
				UNITY_VERTEX_OUTPUT_STEREO
			};

			CBUFFER_START(UnityPerMaterial)
			#ifdef _ENABLEOUTEROUTLINE_ON
			float4 _OuterOutlineColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorB;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float4 _InnerOutlineColor;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideNoiseColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowMask_ST;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float4 _SourceGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float4 _SineGlowColor;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float4 _AddHueMask_ST;
			#endif
			#ifdef _ENABLEBURN_ON
			float4 _BurnInsideColor;
			float4 _BurnEdgeColor;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float4 _InkSpreadColor;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float4 _BlackTintColor;
			#endif
			#ifdef _ENABLESPLITTONING_ON
			float4 _SplitToningHighlightsColor;
			float4 _SplitToningShadowsColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineColor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float4 _ColorReplaceToColor;
			float4 _ColorReplaceFromColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPRedTint;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float4 _EnchantedHighColor;
			float4 _EnchantedLowColor;
			#endif
			#ifdef _ENABLEPOISON_ON
			float4 _PoisonColor;
			#endif
			#ifdef _ENABLESHINE_ON
			float4 _ShineMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBRedTint;
			float4 _RecolorRGBGreenTint;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float4 _DirectionalGlowFadeEdgeColor;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float4 _FullGlowDissolveEdgeColor;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPPurpleTint;
			float4 _RecolorRGBYCPBlueTint;
			float4 _RecolorRGBYCPCyanTint;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float4 _UVDistortMask_ST;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float4 _RecolorRGBYCPGreenTint;
			float4 _RecolorRGBYCPYellowTint;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float4 _RecolorRGBBlueTint;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float4 _PixelOutlineColor;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenHighlightColor;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float4 _ShiftingColorA;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageBaseColor;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintMask_ST;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float4 _AlphaTintColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalColor;
			#endif
			#ifdef _ENABLESHADOW_ON
			float4 _ShadowColor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float4 _MetalMask_ST;
			float4 _MetalHighlightColor;
			#endif
			#ifdef _SPRITESHEETFIX_ON
			float4 _SpriteSheetRect;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorMask_ST;
			#endif
			#ifdef _EMISSIONTOGGLE_ON
			float4 _EmissionTint;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenTint;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorB;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float4 _AddColorColor;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float4 _CamouflageColorA;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float4 _HologramTint;
			#endif
			#ifdef _SHADERFADING_MASK
			float4 _FadingMask_ST;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float4 _StrongTintTint;
			#endif
			float4 _MainTex_TexelSize;
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowTo;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float4 _FrozenSnowColor;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float4 _PingPongGlowFrom;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float2 _EnchantedScale;
			float2 _EnchantedSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortion;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionScale;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float2 _CustomFadeNoiseScale;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageDistortionIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionScale;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleB;
			#endif
			#ifdef _ENABLEFLAME_ON
			float2 _FlameSpeed;
			float2 _FlameNoiseScale;
			#endif
			#ifdef _ENABLEPOISON_ON
			float2 _PoisonNoiseScale;
			float2 _PoisonNoiseSpeed;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float2 _CamouflageNoiseScaleA;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseScale;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionScale;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineDistortionIntensity;
			float2 _OuterOutlineNoiseScale;
			float2 _OuterOutlineNoiseSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortion;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			float2 _OuterOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightSpeed;
			float2 _FrozenHighlightScale;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float2 _InnerOutlineDistortionIntensity;
			float2 _InnerOutlineNoiseScale;
			float2 _InnerOutlineNoiseSpeed;
			float2 _InnerOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenSnowScale;
			#endif
			#ifdef _ENABLEBURN_ON
			float2 _BurnSwirlNoiseScale;
			float2 _BurnInsideNoiseScale;
			float2 _BurnPosition;
			float2 _BurnEdgeNoiseScale;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float2 _InkSpreadNoiseScale;
			float2 _InkSpreadPosition;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float2 _RainbowCenter;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float2 _PixelOutlineTextureSpeed;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchNoiseScale;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float2 _FrozenHighlightDistortionSpeed;
			#endif
			#ifdef _ENABLEMETAL_ON
			float2 _MetalNoiseDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolvePosition;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortNoiseScale;
			float2 _UVDistortSpeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float2 _SineScaleFactor;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortTo;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float2 _HalftonePosition;
			#endif
			float2 _FadingNoiseScale;
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskScale;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float2 _FadingPosition;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float2 _DirectionalGlowFadeNoiseScale;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchMaskSpeed;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeCenter;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortion;
			float2 _GlitchDistortionSpeed;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float2 _SourceAlphaDissolvePosition;
			float2 _SourceAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float2 _DirectionalAlphaFadeNoiseScale;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float2 _SourceGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionNoiseScale;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionNoiseScale;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float2 _FullDistortionDistortion;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float2 _DirectionalDistortionDistortionScale;
			float2 _DirectionalDistortionDistortion;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float2 _GlitchDistortionScale;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float2 _SqueezeScale;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float2 _UVDistortFrom;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float2 _FullGlowDissolveNoiseScale;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float2 _ScreenTilingScale;
			float2 _ScreenTilingOffset;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float2 _WorldTilingScale;
			float2 _WorldTilingOffset;
			#endif
			#ifdef _ENABLESHADOW_ON
			float2 _ShadowOffset;
			#endif
			#ifdef _ENABLEUVSCALE_ON
			float2 _UVScaleScale;
			float2 _UVScalePivot;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveOffset;
			#endif
			#ifdef _ENABLEUVSCROLL_ON
			float2 _UVScrollSpeed;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float2 _SineMoveFrequency;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float2 _UVRotatePivot;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float2 _FullAlphaDissolveNoiseScale;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float2 _SineRotatePivot;
			#endif
			#ifdef _ENABLESHADOW_ON
			float _ShadowFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeInvert;
			#endif
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeWidth;
			float _DirectionalAlphaFadeNoiseFactor;
			float _DirectionalAlphaFadeFade;
			float _DirectionalAlphaFadeRotation;
			#endif
			float _NormalIntensity;
			#ifdef _ENABLEDIRECTIONALALPHAFADE_ON
			float _DirectionalAlphaFadeInvert;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenContrast;
			#endif
			float _Metallic;
			#ifdef _ENABLEADDCOLOR_ON
			float _AddColorContrast;
			#endif
			#ifdef _ENABLEALPHATINT_ON
			float _AlphaTintMinAlpha;
			float _AlphaTintFade;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeRotation;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintFade;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowDensity;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFade;
			float _HalftoneTiling;
			float _HalftoneInvert;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightDensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalContrast;
			#endif
			#ifdef _ENABLEHALFTONE_ON
			float _HalftoneFadeWidth;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeWidth;
			float _DirectionalGlowFadeNoiseFactor;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalFade;
			float _MetalHighlightContrast;
			#endif
			#ifdef _ENABLEDIRECTIONALGLOWFADE_ON
			float _DirectionalGlowFadeFade;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			float _StrongTintContrast;
			#endif
			#ifdef _ENABLEFROZEN_ON
			float _FrozenSnowContrast;
			float _FrozenFade;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedReduce;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveInvert;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineWidth;
			#endif
			#ifdef _ENABLEFULLGLOWDISSOLVE_ON
			float _FullGlowDissolveWidth;
			float _FullGlowDissolveFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineFade;
			#endif
			#ifdef _ENABLEFULLALPHADISSOLVE_ON
			float _FullAlphaDissolveWidth;
			float _FullAlphaDissolveFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonShiftSpeed;
			float _PoisonDensity;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingFade;
			float _ShiftingContrast;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonFade;
			float _PoisonNoiseBrightness;
			#endif
			#ifdef _ENABLESHIFTING_ON
			float _ShiftingSaturation;
			float _ShiftingBrightness;
			float _ShiftingDensity;
			float _ShiftingSpeed;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedRainbowDensity;
			float _EnchantedRainbowSpeed;
			float _EnchantedRainbowSaturation;
			float _EnchantedContrast;
			float _EnchantedBrightness;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSpeed;
			float _ShineFrequency;
			float _ShineRotation;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveInvert;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnInsideNoiseFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveWidth;
			float _SourceGlowDissolveFade;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnSwirlFactor;
			#endif
			#ifdef _ENABLESOURCEGLOWDISSOLVE_ON
			float _SourceGlowDissolveNoiseFactor;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnRadius;
			#endif
			#ifdef _ENABLEENCHANTED_ON
			float _EnchantedFade;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveWidth;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnEdgeNoiseFactor;
			float _BurnWidth;
			float _BurnInsideContrast;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveNoiseFactor;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowNoiseFactor;
			float _RainbowDensity;
			float _RainbowSpeed;
			float _RainbowSaturation;
			float _RainbowBrightness;
			#endif
			#ifdef _ENABLESOURCEALPHADISSOLVE_ON
			float _SourceAlphaDissolveFade;
			#endif
			#ifdef _ENABLERAINBOW_ON
			float _RainbowContrast;
			float _RainbowFade;
			#endif
			#ifdef _ENABLESHINE_ON
			float _ShineSaturation;
			float _ShineContrast;
			#endif
			#ifdef _ENABLEBURN_ON
			float _BurnFade;
			#endif
			#ifdef _ENABLEPOISON_ON
			float _PoisonRecolorFactor;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishStretch;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionInvert;
			float _DirectionalDistortionRotation;
			float _DirectionalDistortionFade;
			float _DirectionalDistortionNoiseFactor;
			float _DirectionalDistortionWidth;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramDistortionSpeed;
			float _HologramDistortionDensity;
			float _HologramDistortionScale;
			float _HologramDistortionOffset;
			float _HologramFade;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchMaskMin;
			float _GlitchFade;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			float _UVDistortFade;
			#endif
			#ifdef _ENABLESQUEEZE_ON
			float _SqueezePower;
			float _SqueezeFade;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFrequency;
			float _SineRotateAngle;
			#endif
			#ifdef _ENABLESHARPEN_ON
			float _SharpenFade;
			float _SharpenFactor;
			float _SharpenOffset;
			#endif
			#ifdef _ENABLEGAUSSIANBLUR_ON
			float _GaussianBlurFade;
			float _GaussianBlurOffset;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleFade;
			#endif
			#ifdef _ENABLEDIRECTIONALDISTORTION_ON
			float _DirectionalDistortionRandomDirection;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleOffset;
			float _WiggleFrequency;
			#endif
			#ifdef _ENABLEPIXELATE_ON
			float _PixelateFade;
			float _PixelatePixelsPerUnit;
			float _PixelatePixelDensity;
			#endif
			#ifdef _ENABLEUVROTATE_ON
			float _UVRotateSpeed;
			#endif
			#ifdef _ENABLESINEROTATE_ON
			float _SineRotateFade;
			#endif
			#ifdef _ENABLEWIGGLE_ON
			float _WiggleSpeed;
			#endif
			#ifdef _ENABLEFULLDISTORTION_ON
			float _FullDistortionFade;
			#endif
			#ifdef _ENABLEWIND_ON
			float _WindSquishWindFactor;
			float _WindSquishFactor;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateFade;
			float _VibrateOffset;
			float _VibrateFrequency;
			#endif
			#ifdef _ENABLESINEMOVE_ON
			float _SineMoveFade;
			#endif
			#ifdef _TOGGLETIMEFREQUENCY_ON
			float _TimeRange;
			float _TimeFrequency;
			#endif
			#ifdef _ENABLEVIBRATE_ON
			float _VibrateRotation;
			#endif
			#ifdef _TOGGLETIMEFPS_ON
			float _TimeFPS;
			#endif
			#ifdef _TOGGLECUSTOMTIME_ON
			float _TimeValue;
			#endif
			#ifdef _ENABLESQUISH_ON
			float _SquishSquish;
			float _SquishFlip;
			float _SquishFade;
			#endif
			#ifdef _ENABLEWORLDTILING_ON
			float _WorldTilingPixelsPerUnit;
			#endif
			#ifdef _ENABLESCREENTILING_ON
			float _ScreenTilingPixelsPerUnit;
			#endif
			#ifdef _TOGGLETIMESPEED_ON
			float _TimeSpeed;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeVertexSeed;
			#endif
			#ifdef _ENABLESINESCALE_ON
			float _SineScaleFrequency;
			#endif
			float _FadingWidth;
			#ifdef _ENABLEWIND_ON
			float _WindFlip;
			float _WindMaxRotation;
			float _WindRotation;
			float _WindNoiseSpeed;
			float _WindNoiseScale;
			float _WindXPosition;
			#endif
			float _FadingFade;
			#ifdef _ENABLEWIND_ON
			float _WindMaxIntensity;
			float _WindRotationWindFactor;
			#endif
			#ifdef _SHADERFADING_SPREAD
			float _FadingNoiseFactor;
			#endif
			#ifdef _SHADERSPACE_SCREEN
			float _ScreenWidthUnits;
			#endif
			#ifdef _SHADERSPACE_UI_GRAPHIC
			float _RectHeight;
			float _RectWidth;
			#endif
			float _PixelsPerUnit;
			#ifdef _ENABLEWIND_ON
			float _WindMinIntensity;
			#endif
			#ifdef _ENABLEMETAL_ON
			float _MetalHighlightDensity;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseScale;
			float _SmokeSmoothness;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueBrightness;
			float _AddHueContrast;
			float _AddHueFade;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			float _SineGlowContrast;
			float _SineGlowFade;
			float _SineGlowFrequency;
			float _SineGlowMax;
			float _SineGlowMin;
			#endif
			#ifdef _ENABLESATURATION_ON
			float _Saturation;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			float _InnerOutlineFade;
			float _InnerOutlineWidth;
			#endif
			float _Smoothness;
			#ifdef _ENABLEOUTEROUTLINE_ON
			float _OuterOutlineFade;
			float _OuterOutlineWidth;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			float _PixelOutlineFade;
			float _PixelOutlineWidth;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowFrequency;
			#endif
			#ifdef _ENABLECAMOUFLAGE_ON
			float _CamouflageContrast;
			float _CamouflageSmoothnessB;
			float _CamouflageDensityB;
			float _CamouflageSmoothnessA;
			float _CamouflageDensityA;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchHueSpeed;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSaturation;
			#endif
			#ifdef _ENABLEGLITCH_ON
			float _GlitchBrightness;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramLineGap;
			float _HologramLineFrequency;
			float _HologramLineSpeed;
			float _HologramContrast;
			#endif
			#ifdef _ENABLEPINGPONGGLOW_ON
			float _PingPongGlowContrast;
			float _PingPongGlowFade;
			#endif
			#ifdef _ENABLEHOLOGRAM_ON
			float _HologramMinAlpha;
			#endif
			#ifdef _ENABLEADDHUE_ON
			float _AddHueSpeed;
			#endif
			#ifdef _ENABLESHIFTHUE_ON
			float _ShiftHueSpeed;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadWidth;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			float _RecolorRGBYCPFade;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			float _RecolorRGBFade;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameBrightness;
			float _FlameSmooth;
			float _FlameRadius;
			float _FlameNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceContrast;
			#endif
			#ifdef _ENABLEFLAME_ON
			float _FlameNoiseHeightFactor;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardDarken;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			float _CustomFadeAlpha;
			float _CustomFadeSmoothness;
			float _CustomFadeNoiseFactor;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeAlpha;
			float _SmokeDarkEdge;
			#endif
			#ifdef _ENABLECHECKERBOARD_ON
			float _CheckerboardTiling;
			#endif
			#ifdef _ENABLESMOKE_ON
			float _SmokeNoiseFactor;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceSmoothness;
			float _ColorReplaceFade;
			#endif
			#ifdef _ENABLEINKSPREAD_ON
			float _InkSpreadNoiseFactor;
			float _InkSpreadDistance;
			float _InkSpreadFade;
			float _InkSpreadContrast;
			#endif
			#ifdef _ENABLEBLACKTINT_ON
			float _BlackTintFade;
			float _BlackTintPower;
			#endif
			#ifdef _ENABLECOLORREPLACE_ON
			float _ColorReplaceRange;
			#endif
			float _SplitToningFade;
			float _SplitToningBalance;
			#ifdef _ENABLESPLITTONING_ON
			float _SplitToningShift;
			#endif
			float _Hue;
			float _Brightness;
			float _Contrast;
			float _NegativeFade;
			float _SplitToningContrast;
			float _ShadowClip;
			#ifdef ASE_TRANSMISSION
				float _TransmissionShadow;
			#endif
			#ifdef ASE_TRANSLUCENCY
				float _TransStrength;
				float _TransNormal;
				float _TransScattering;
				float _TransDirect;
				float _TransAmbient;
				float _TransShadow;
			#endif
			#ifdef ASE_TESSELLATION
				float _TessPhongStrength;
				float _TessValue;
				float _TessMin;
				float _TessMax;
				float _TessEdgeLength;
				float _TessMaxDisp;
			#endif
			CBUFFER_END

			// Property used by ScenePickingPass
			#ifdef SCENEPICKINGPASS
				float4 _SelectionID;
			#endif

			// Properties used by SceneSelectionPass
			#ifdef SCENESELECTIONPASS
				int _ObjectId;
				int _PassValue;
			#endif

			sampler2D _MainTex;
			#ifdef _TOGGLEUNSCALEDTIME_ON
			float UnscaledTime;
			#endif
			#ifdef _SHADERFADING_MASK
			sampler2D _FadingMask;
			#endif
			sampler2D _UberNoiseTexture;
			#ifdef _ENABLEWIND_ON
			float WindMinIntensity;
			float WindMaxIntensity;
			float WindNoiseScale;
			float WindTime;
			#endif
			#ifdef _ENABLEUVDISTORT_ON
			sampler2D _UVDistortMask;
			#endif
			#ifdef _ENABLECUSTOMFADE_ON
			sampler2D _CustomFadeFadeMask;
			#endif
			#ifdef _ENABLERECOLORRGB_ON
			sampler2D _RecolorRGBTexture;
			#endif
			#ifdef _ENABLERECOLORRGBYCP_ON
			sampler2D _RecolorRGBYCPTexture;
			#endif
			#ifdef _ENABLEADDHUE_ON
			sampler2D _AddHueMask;
			#endif
			#ifdef _ENABLESINEGLOW_ON
			sampler2D _SineGlowMask;
			#endif
			#ifdef _ENABLEINNEROUTLINE_ON
			sampler2D _InnerOutlineTintTexture;
			#endif
			#ifdef _ENABLEOUTEROUTLINE_ON
			sampler2D _OuterOutlineTintTexture;
			#endif
			#ifdef _ENABLEPIXELOUTLINE_ON
			sampler2D _PixelOutlineTintTexture;
			#endif
			#ifdef _ENABLEMETAL_ON
			sampler2D _MetalMask;
			#endif
			#ifdef _ENABLESHINE_ON
			sampler2D _ShineMask;
			#endif
			#ifdef _ENABLEADDCOLOR_ON
			sampler2D _AddColorMask;
			#endif
			#ifdef _ENABLESTRONGTINT_ON
			sampler2D _StrongTintMask;
			#endif
			sampler2D _NormalMap;
			#ifdef _EMISSIONTOGGLE_ON
			sampler2D _EmissionMap;
			#endif
			#ifdef _METALLICMAPTOGGLE_ON
			sampler2D _MetallicMap;
			#endif


			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/Varyings.hlsl"
			#include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/UnityGBuffer.hlsl"
			//#include "Packages/com.unity.render-pipelines.universal/Editor/ShaderGraph/Includes/PBRGBufferPass.hlsl"

			float3 RotateAroundAxis( float3 center, float3 original, float3 u, float angle )
			{
				original -= center;
				float C = cos( angle );
				float S = sin( angle );
				float t = 1 - C;
				float m00 = t * u.x * u.x + C;
				float m01 = t * u.x * u.y - S * u.z;
				float m02 = t * u.x * u.z + S * u.y;
				float m10 = t * u.x * u.y + S * u.z;
				float m11 = t * u.y * u.y + C;
				float m12 = t * u.y * u.z - S * u.x;
				float m20 = t * u.x * u.z - S * u.y;
				float m21 = t * u.y * u.z + S * u.x;
				float m22 = t * u.z * u.z + C;
				float3x3 finalMatrix = float3x3( m00, m01, m02, m10, m11, m12, m20, m21, m22 );
				return mul( finalMatrix, original ) + center;
			}
			
			float MyCustomExpression16_g11712( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11715( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float FastNoise101_g11667( float x )
			{
				float i = floor(x);
				float f = frac(x);
				float s = sign(frac(x/2.0)-0.5);
				    
				float k = 0.5+0.5*sin(i);
				return s*f*(f-1.0)*((16.0*k-4.0)*f*(f-1.0)-1.0);
			}
			
			float3 mod2D289( float3 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float2 mod2D289( float2 x ) { return x - floor( x * ( 1.0 / 289.0 ) ) * 289.0; }
			float3 permute( float3 x ) { return mod2D289( ( ( x * 34.0 ) + 1.0 ) * x ); }
			float snoise( float2 v )
			{
				const float4 C = float4( 0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439 );
				float2 i = floor( v + dot( v, C.yy ) );
				float2 x0 = v - i + dot( i, C.xx );
				float2 i1;
				i1 = ( x0.x > x0.y ) ? float2( 1.0, 0.0 ) : float2( 0.0, 1.0 );
				float4 x12 = x0.xyxy + C.xxzz;
				x12.xy -= i1;
				i = mod2D289( i );
				float3 p = permute( permute( i.y + float3( 0.0, i1.y, 1.0 ) ) + i.x + float3( 0.0, i1.x, 1.0 ) );
				float3 m = max( 0.5 - float3( dot( x0, x0 ), dot( x12.xy, x12.xy ), dot( x12.zw, x12.zw ) ), 0.0 );
				m = m * m;
				m = m * m;
				float3 x = 2.0 * frac( p * C.www ) - 1.0;
				float3 h = abs( x ) - 0.5;
				float3 ox = floor( x + 0.5 );
				float3 a0 = x - ox;
				m *= 1.79284291400159 - 0.85373472095314 * ( a0 * a0 + h * h );
				float3 g;
				g.x = a0.x * x0.x + h.x * x0.y;
				g.yz = a0.yz * x12.xz + h.yz * x12.yw;
				return 130.0 * dot( m, g );
			}
			
			float MyCustomExpression16_g11669( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11670( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11673( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11672( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11678( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11679( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11717( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11675( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11728( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float4 texturePointSmooth( sampler2D tex, float4 textureTexelSize, float2 uvs )
			{
				float2 size;
				size.x = textureTexelSize.z;
				size.y = textureTexelSize.w;
				float2 pixel = float2(1.0,1.0) / size;
				uvs -= pixel * float2(0.5,0.5);
				float2 uv_pixels = uvs * size;
				float2 delta_pixel = frac(uv_pixels) - float2(0.5,0.5);
				float2 ddxy = fwidth(uv_pixels);
				float2 mip = log2(ddxy) - 0.5;
				float2 clampedUV = uvs + (clamp(delta_pixel / ddxy, 0.0, 1.0) - delta_pixel) * pixel;
				return tex2Dlod(tex, float4(clampedUV,0, min(mip.x, mip.y)));
			}
			
			float MyCustomExpression16_g11754( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11756( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11760( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float3 RGBToHSV(float3 c)
			{
				float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
				float4 p = lerp( float4( c.bg, K.wz ), float4( c.gb, K.xy ), step( c.b, c.g ) );
				float4 q = lerp( float4( p.xyw, c.r ), float4( c.r, p.yzx ), step( p.x, c.r ) );
				float d = q.x - min( q.w, q.y );
				float e = 1.0e-10;
				return float3( abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
			}
			float3 MyCustomExpression115_g11764( float3 In, float3 From, float3 To, float Fuzziness, float Range )
			{
				float Distance = distance(From, In);
				return lerp(To, In, saturate((Distance - Range) / max(Fuzziness, 0.001)));
			}
			
			float3 HSVToRGB( float3 c )
			{
				float4 K = float4( 1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0 );
				float3 p = abs( frac( c.xxx + K.xyz ) * 6.0 - K.www );
				return c.z * lerp( K.xxx, saturate( p - K.xxx ), c.y );
			}
			
			float MyCustomExpression16_g11783( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11770( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11794( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11801( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11834( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11831( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11833( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11824( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11826( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11819( float linValue )
			{
				#ifdef UNITY_COLORSPACE_GAMMA
				return linValue;
				#else
				linValue = max(linValue, half3(0.h, 0.h, 0.h));
				return max(1.055h * pow(linValue, 0.416666667h) - 0.055h, 0.h);
				#endif
			}
			
			float MyCustomExpression16_g11821( float linValue )
			{
				